/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNotationParser<T>
implements NotationParser<T> {
    private final Collection<NotationParser<? extends T>> delegates;

    public CompositeNotationParser(NotationParser<? extends T> ... notationParserArray) {
        this.delegates = Arrays.asList(notationParserArray);
    }

    public CompositeNotationParser(Collection<NotationParser<? extends T>> collection) {
        assert (collection != null) : "delegates cannot be null!";
        this.delegates = collection;
    }

    @Override
    public void describe(Collection<String> collection) {
        for (NotationParser<T> notationParser : this.delegates) {
            notationParser.describe(collection);
        }
    }

    @Override
    public T parseNotation(Object object) {
        for (NotationParser<T> notationParser : this.delegates) {
            try {
                return notationParser.parseNotation(object);
            }
            catch (UnsupportedNotationException unsupportedNotationException) {
            }
        }
        throw new UnsupportedNotationException(object);
    }
}

