/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.DefaultScriptHandler;
import org.gradle.api.internal.initialization.NoClassLoaderUpdateScriptHandler;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.MutableURLClassLoader;

public class DefaultScriptHandlerFactory
implements ScriptHandlerFactory {
    private final DependencyManagementServices dependencyManagementServices;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final Map<Collection<Object>, MutableURLClassLoader> classLoaderCache = new HashMap<Collection<Object>, MutableURLClassLoader>();
    private final FileResolver fileResolver;
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public ProjectInternal getProject(String string) {
            throw new UnknownProjectException("Cannot use project dependencies in a script classpath definition.");
        }
    };

    public DefaultScriptHandlerFactory(DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, DependencyMetaDataProvider dependencyMetaDataProvider) {
        this.dependencyManagementServices = dependencyManagementServices;
        this.fileResolver = fileResolver;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
    }

    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoader classLoader) {
        return this.create(scriptSource, classLoader, new BasicDomainObjectContext());
    }

    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoader classLoader, DomainObjectContext domainObjectContext) {
        DependencyResolutionServices dependencyResolutionServices = this.dependencyManagementServices.create(this.fileResolver, this.dependencyMetaDataProvider, this.projectFinder, domainObjectContext);
        RepositoryHandler repositoryHandler = dependencyResolutionServices.getResolveRepositoryHandler();
        ConfigurationContainerInternal configurationContainerInternal = dependencyResolutionServices.getConfigurationContainer();
        DependencyHandler dependencyHandler = dependencyResolutionServices.getDependencyHandler();
        List<Object> list = Arrays.asList(scriptSource.getClassName(), classLoader);
        MutableURLClassLoader mutableURLClassLoader = this.classLoaderCache.get(list);
        if (mutableURLClassLoader == null) {
            mutableURLClassLoader = new MutableURLClassLoader(classLoader, new URL[0]);
            this.classLoaderCache.put(list, mutableURLClassLoader);
            return new DefaultScriptHandler(scriptSource, repositoryHandler, dependencyHandler, configurationContainerInternal, mutableURLClassLoader);
        }
        return new NoClassLoaderUpdateScriptHandler(mutableURLClassLoader, repositoryHandler, dependencyHandler, scriptSource, configurationContainerInternal);
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String string) {
            return string;
        }
    }
}

