/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.pattern.PatternStep;

public class RegExpPatternStep
implements PatternStep {
    private static final String ESCAPE_CHARS = "\\[]^-&.{}()$+|<=!";
    private static final String PATTERN_CHARS = "*?";
    private final Pattern pattern;

    public RegExpPatternStep(String string, boolean bl) {
        this.pattern = Pattern.compile(RegExpPatternStep.getRegExPattern(string), bl ? 0 : 2);
    }

    protected static String getRegExPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ESCAPE_CHARS.indexOf(c) >= 0) {
                stringBuilder.append('\\');
            } else if (PATTERN_CHARS.indexOf(c) >= 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean matches(String string, boolean bl) {
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }

    public boolean isGreedy() {
        return false;
    }
}

