/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPatternMatcher
implements Spec<RelativePath> {
    private List<PatternStep> steps;
    private boolean partialMatchDirs;

    public DefaultPatternMatcher(boolean bl, boolean bl2, String ... stringArray) {
        this.partialMatchDirs = bl;
        this.steps = new ArrayList<PatternStep>();
        this.compile(bl2, stringArray);
    }

    private void compile(boolean bl, String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.steps.add(PatternStepFactory.getStep(stringArray[i], i == stringArray.length - 1, bl));
            }
        }
    }

    @Override
    public boolean isSatisfiedBy(RelativePath relativePath) {
        ListIterator<PatternStep> listIterator = this.steps.listIterator();
        ListIterator<String> listIterator2 = relativePath.segmentIterator();
        boolean bl = false;
        while (listIterator2.hasNext()) {
            String string = listIterator2.next();
            if (!listIterator.hasNext()) {
                return false;
            }
            PatternStep patternStep = listIterator.next();
            if (patternStep.isGreedy()) {
                bl = true;
                this.advancePatternStepToNextNonGreedy(listIterator);
                if (!listIterator.hasNext()) {
                    return true;
                }
                patternStep = listIterator.next();
                while (!patternStep.matches(string, !listIterator2.hasNext() && relativePath.isFile()) || listIterator.hasNext() != listIterator2.hasNext() && !this.nextPatternIsGreedy(listIterator)) {
                    if (!listIterator2.hasNext()) {
                        return this.partialMatchDirs && !relativePath.isFile();
                    }
                    string = listIterator2.next();
                }
                continue;
            }
            if (patternStep.matches(string, !listIterator2.hasNext() && relativePath.isFile())) continue;
            if (bl) {
                this.rewindPatternStepToPreviousGreedy(listIterator);
                listIterator2.previous();
                continue;
            }
            return false;
        }
        if (!listIterator.hasNext()) {
            return true;
        }
        return this.isTerminatingMatch(relativePath, listIterator);
    }

    private boolean nextPatternIsGreedy(ListIterator<PatternStep> listIterator) {
        boolean bl = false;
        if (listIterator.hasNext()) {
            PatternStep patternStep = listIterator.next();
            if (patternStep.isGreedy() && !listIterator.hasNext()) {
                bl = true;
            }
            listIterator.previous();
        }
        return bl;
    }

    private boolean isTerminatingMatch(RelativePath relativePath, ListIterator<PatternStep> listIterator) {
        PatternStep patternStep;
        if (listIterator.hasNext() && (patternStep = listIterator.next()).isGreedy() && !listIterator.hasNext()) {
            return true;
        }
        return !relativePath.isFile() && this.partialMatchDirs;
    }

    private void advancePatternStepToNextNonGreedy(ListIterator<PatternStep> listIterator) {
        PatternStep patternStep = null;
        while (listIterator.hasNext() && (patternStep = listIterator.next()).isGreedy()) {
        }
        if (patternStep != null && !patternStep.isGreedy()) {
            listIterator.previous();
        }
    }

    private void rewindPatternStepToPreviousGreedy(ListIterator<PatternStep> listIterator) {
        PatternStep patternStep = null;
        while (listIterator.hasPrevious()) {
            patternStep = listIterator.previous();
            if (!patternStep.isGreedy()) continue;
            return;
        }
        throw new IllegalStateException("PatternStep list iterator in non-greedy state when rewindToLastGreedy");
    }

    List<PatternStep> getStepsForTest() {
        return this.steps;
    }
}

