/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.util.GFileUtils;

public class SyncCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private final Set<RelativePath> visited = new HashSet<RelativePath>();
    private File baseDestDir;
    private boolean didWork;

    public SyncCopySpecVisitor(CopySpecVisitor copySpecVisitor) {
        super(copySpecVisitor);
    }

    public void startVisit(CopyAction copyAction) {
        this.baseDestDir = ((FileCopyAction)copyAction).getDestinationDir();
        this.getVisitor().startVisit(copyAction);
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        this.visited.add(fileVisitDetails.getRelativePath());
        this.getVisitor().visitDir(fileVisitDetails);
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        this.visited.add(fileVisitDetails.getRelativePath());
        this.getVisitor().visitFile(fileVisitDetails);
    }

    public void endVisit() {
        FileVisitor fileVisitor = new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
                this.maybeDelete(fileVisitDetails, true);
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                this.maybeDelete(fileVisitDetails, false);
            }

            private void maybeDelete(FileVisitDetails fileVisitDetails, boolean bl) {
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                if (!SyncCopySpecVisitor.this.visited.contains(relativePath)) {
                    if (bl) {
                        GFileUtils.deleteDirectory(fileVisitDetails.getFile());
                    } else {
                        GFileUtils.deleteQuietly(fileVisitDetails.getFile());
                    }
                    SyncCopySpecVisitor.this.didWork = true;
                }
            }
        };
        DirectoryFileTree directoryFileTree = new DirectoryFileTree(this.baseDestDir).depthFirst();
        directoryFileTree.visit(fileVisitor);
        this.visited.clear();
        this.getVisitor().endVisit();
    }

    public boolean getDidWork() {
        return this.didWork || this.getVisitor().getDidWork();
    }
}

