/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNotationParser<T extends String>
implements NotationParser<T> {
    @Override
    public void describe(Collection<String> collection) {
        collection.add("Strings, Boolean, Number like: 'path/to', true, Boolean.TRUE, 42, 3.14");
        collection.add("Closures, Callables");
    }

    @Override
    public T parseNotation(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CharSequence || object instanceof Number || object instanceof Boolean) {
            return (T)object.toString();
        }
        if (object instanceof Closure) {
            Closure closure = (Closure)object;
            Object object2 = closure.call();
            return (T)this.parseNotation(object2);
        }
        if (object instanceof Callable) {
            try {
                Callable callable = (Callable)object;
                Object v = callable.call();
                return (T)this.parseNotation(v);
            }
            catch (Exception exception) {
                throw UncheckedException.throwAsUncheckedException((Throwable)exception);
            }
        }
        DeprecationLogger.nagUserWith(String.format("Converting class %s to path using toString() Method. This has been deprecated and will be removed in the next version of Gradle. Please use java.io.File, java.lang.CharSequence, java.lang.Number, java.util.concurrent.Callable or groovy.lang.Closure.", object.getClass().getName()));
        return (T)object.toString();
    }
}

