/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.ReadableCopySpec;

public class NormalizingCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private ReadableCopySpec spec;
    private final Set<RelativePath> visitedDirs = new HashSet<RelativePath>();
    private final Map<RelativePath, FileVisitDetails> pendingDirs = new HashMap<RelativePath, FileVisitDetails>();

    public NormalizingCopySpecVisitor(CopySpecVisitor copySpecVisitor) {
        super(copySpecVisitor);
    }

    public void visitSpec(ReadableCopySpec readableCopySpec) {
        this.spec = readableCopySpec;
        this.getVisitor().visitSpec(readableCopySpec);
    }

    public void endVisit() {
        if (this.spec.getIncludeEmptyDirs()) {
            for (RelativePath relativePath : new ArrayList<RelativePath>(this.pendingDirs.keySet())) {
                this.maybeVisit(relativePath);
            }
        }
        this.visitedDirs.clear();
        this.pendingDirs.clear();
        this.getVisitor().endVisit();
    }

    private void maybeVisit(RelativePath relativePath) {
        if (relativePath == null || relativePath.getParent() == null || !this.visitedDirs.add(relativePath)) {
            return;
        }
        this.maybeVisit(relativePath.getParent());
        FileVisitDetails fileVisitDetails = this.pendingDirs.remove(relativePath);
        if (fileVisitDetails == null) {
            fileVisitDetails = new FileVisitDetailsImpl(relativePath);
        }
        this.getVisitor().visitDir(fileVisitDetails);
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        this.maybeVisit(fileVisitDetails.getRelativePath().getParent());
        this.getVisitor().visitFile(fileVisitDetails);
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        RelativePath relativePath = fileVisitDetails.getRelativePath();
        if (!this.visitedDirs.contains(relativePath)) {
            this.pendingDirs.put(relativePath, fileVisitDetails);
        }
    }

    private static class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private long lastModified = System.currentTimeMillis();

        private FileVisitDetailsImpl(RelativePath relativePath) {
            this.path = relativePath;
        }

        public String getDisplayName() {
            return this.path.toString();
        }

        public void stopVisiting() {
            throw new UnsupportedOperationException();
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            return !this.path.isFile();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            throw new UnsupportedOperationException();
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return this.path;
        }
    }
}

