/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.FilterChain;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;

public class MappingCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private ReadableCopySpec spec;

    public MappingCopySpecVisitor(CopySpecVisitor copySpecVisitor) {
        super(copySpecVisitor);
    }

    public void visitSpec(ReadableCopySpec readableCopySpec) {
        this.spec = readableCopySpec;
        this.getVisitor().visitSpec(readableCopySpec);
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        this.getVisitor().visitDir(new FileVisitDetailsImpl(fileVisitDetails, this.spec));
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        FileVisitDetailsImpl fileVisitDetailsImpl = new FileVisitDetailsImpl(fileVisitDetails, this.spec);
        for (Action<? super FileCopyDetails> action : this.spec.getAllCopyActions()) {
            action.execute(fileVisitDetailsImpl);
            if (!fileVisitDetailsImpl.excluded) continue;
            return;
        }
        this.getVisitor().visitFile(fileVisitDetailsImpl);
    }

    private static class ByteCountingOutputStream
    extends OutputStream {
        long size;

        private ByteCountingOutputStream() {
        }

        public void write(int n) throws IOException {
            ++this.size;
        }

        public void write(byte[] byArray) throws IOException {
            this.size += (long)byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.size += (long)n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails,
    FileCopyDetails {
        private final FileVisitDetails fileDetails;
        private final ReadableCopySpec spec;
        private final FilterChain filterChain = new FilterChain();
        private RelativePath relativePath;
        private boolean excluded;
        private Integer mode;

        public FileVisitDetailsImpl(FileVisitDetails fileVisitDetails, ReadableCopySpec readableCopySpec) {
            this.fileDetails = fileVisitDetails;
            this.spec = readableCopySpec;
        }

        @Override
        public String getDisplayName() {
            return this.fileDetails.toString();
        }

        @Override
        public void stopVisiting() {
            this.fileDetails.stopVisiting();
        }

        @Override
        public File getFile() {
            if (this.filterChain.hasFilters()) {
                throw new UnsupportedOperationException();
            }
            return this.fileDetails.getFile();
        }

        @Override
        public boolean isDirectory() {
            return this.fileDetails.isDirectory();
        }

        @Override
        public long getLastModified() {
            return this.fileDetails.getLastModified();
        }

        @Override
        public long getSize() {
            if (this.filterChain.hasFilters()) {
                ByteCountingOutputStream byteCountingOutputStream = new ByteCountingOutputStream();
                this.copyTo(byteCountingOutputStream);
                return byteCountingOutputStream.size;
            }
            return this.fileDetails.getSize();
        }

        @Override
        public InputStream open() {
            if (this.filterChain.hasFilters()) {
                return this.filterChain.transform(this.fileDetails.open());
            }
            return this.fileDetails.open();
        }

        @Override
        public void copyTo(OutputStream outputStream) {
            if (this.filterChain.hasFilters()) {
                super.copyTo(outputStream);
            } else {
                this.fileDetails.copyTo(outputStream);
            }
        }

        @Override
        public boolean copyTo(File file) {
            if (this.filterChain.hasFilters()) {
                return super.copyTo(file);
            }
            boolean bl = this.fileDetails.copyTo(file);
            this.adaptPermissionSpecs(file);
            return bl;
        }

        private void adaptPermissionSpecs(File file) {
            Integer n = this.getSpecMode();
            if (n != null) {
                try {
                    FileSystems.getDefault().chmod(file, n.intValue());
                }
                catch (IOException iOException) {
                    throw new GradleException(String.format("Could not set permission %s on '%s'.", n, file), iOException);
                }
            }
        }

        @Override
        public RelativePath getRelativePath() {
            if (this.relativePath == null) {
                RelativePath relativePath = this.fileDetails.getRelativePath();
                this.relativePath = this.spec.getDestPath().append(relativePath.isFile(), relativePath.getSegments());
            }
            return this.relativePath;
        }

        @Override
        public int getMode() {
            if (this.mode != null) {
                return this.mode;
            }
            Integer n = this.getSpecMode();
            if (n != null) {
                return n;
            }
            return this.fileDetails.getMode();
        }

        private Integer getSpecMode() {
            return this.fileDetails.isDirectory() ? this.spec.getDirMode() : this.spec.getFileMode();
        }

        @Override
        public void setRelativePath(RelativePath relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public void setName(String string) {
            this.relativePath = this.getRelativePath().replaceLastName(string);
        }

        @Override
        public void setPath(String string) {
            this.relativePath = RelativePath.parse(this.getRelativePath().isFile(), string);
        }

        @Override
        public void exclude() {
            this.excluded = true;
        }

        @Override
        public void setMode(int n) {
            this.mode = n;
        }

        @Override
        public ContentFilterable filter(Closure closure) {
            this.filterChain.add(closure);
            return this;
        }

        @Override
        public ContentFilterable filter(Map<String, ?> map, Class<? extends FilterReader> clazz) {
            this.filterChain.add(clazz, map);
            return this;
        }

        @Override
        public ContentFilterable filter(Class<? extends FilterReader> clazz) {
            this.filterChain.add(clazz);
            return this;
        }

        @Override
        public ContentFilterable expand(Map<String, ?> map) {
            this.filterChain.expand(map);
            return this;
        }
    }
}

