/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.gradle.internal.SystemProperties;

public class LineFilter
extends Reader {
    private final Closure closure;
    private String transformedLine;
    private int transformedIndex;
    private final BufferedReader bufferedIn;
    private final Reader in;

    public LineFilter(Reader reader, Closure closure) {
        this.in = reader;
        this.bufferedIn = new BufferedReader(reader);
        this.closure = closure;
    }

    private String getTransformedLine() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!bl && (n = this.bufferedIn.read()) >= 0) {
            if (n == 10) {
                bl = true;
                continue;
            }
            if (n == 13) {
                bl = true;
                this.bufferedIn.mark(1);
                if (this.bufferedIn.read() == 10) continue;
                this.bufferedIn.reset();
                continue;
            }
            stringBuilder.append((char)n);
        }
        if (stringBuilder.length() == 0 && !bl) {
            return null;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.closure.call((Object)stringBuilder.toString()).toString());
        if (bl) {
            stringBuilder2.append(SystemProperties.getLineSeparator());
        }
        return stringBuilder2.toString();
    }

    private void ensureData() throws IOException {
        if (this.transformedLine == null || this.transformedIndex >= this.transformedLine.length()) {
            this.transformedLine = this.getTransformedLine();
            this.transformedIndex = 0;
        }
    }

    public int read() throws IOException {
        this.ensureData();
        if (this.transformedLine == null || this.transformedLine.length() == 0) {
            return -1;
        }
        return this.transformedLine.charAt(this.transformedIndex++);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

