/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.tools.ant.util.ReaderInputStream;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.file.copy.LineFilter;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChain
implements Transformer<InputStream, InputStream> {
    private final ChainingTransformer<Reader> transformers = new ChainingTransformer<Reader>(Reader.class);

    @Override
    public Reader transform(Reader reader) {
        return this.transformers.transform(reader);
    }

    @Override
    public InputStream transform(InputStream inputStream) {
        return new ReaderInputStream(this.transform(new InputStreamReader(inputStream)));
    }

    public boolean hasFilters() {
        return this.transformers.hasTransformers();
    }

    public void add(Class<? extends FilterReader> clazz) {
        this.add(clazz, null);
    }

    public void add(final Class<? extends FilterReader> clazz, final Map<String, ?> map) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            @Override
            public Reader transform(Reader reader) {
                try {
                    Constructor constructor = clazz.getConstructor(Reader.class);
                    FilterReader filterReader = (FilterReader)constructor.newInstance(reader);
                    if (map != null) {
                        ConfigureUtil.configureByMap(map, filterReader);
                    }
                    return filterReader;
                }
                catch (Throwable throwable) {
                    throw new InvalidUserDataException("Error - Invalid filter specification for " + clazz.getName(), throwable);
                }
            }
        });
    }

    public void add(final Closure closure) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            @Override
            public Reader transform(Reader reader) {
                return new LineFilter(reader, closure);
            }
        });
    }

    public void expand(final Map<String, ?> map) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Reader transform(Reader reader) {
                try {
                    Template template;
                    Object object;
                    try {
                        object = new SimpleTemplateEngine();
                        template = object.createTemplate(reader);
                    }
                    finally {
                        reader.close();
                    }
                    object = new StringWriter();
                    template.make(map).writeTo((Writer)object);
                    return new StringReader(((StringWriter)object).toString());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
        });
    }
}

