/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;
import org.gradle.api.internal.file.copy.FileCopyAction;

public class FileCopySpecVisitor
extends EmptyCopySpecVisitor {
    private File baseDestDir;
    private boolean didWork;

    public void startVisit(CopyAction copyAction) {
        this.baseDestDir = ((FileCopyAction)copyAction).getDestinationDir();
        if (this.baseDestDir == null) {
            throw new InvalidUserDataException("No copy destination directory has been specified, use 'into' to specify a target directory.");
        }
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        this.visitFileOrDir(fileVisitDetails);
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        this.visitFileOrDir(fileVisitDetails);
    }

    public boolean getDidWork() {
        return this.didWork;
    }

    private void visitFileOrDir(FileVisitDetails fileVisitDetails) {
        File file = fileVisitDetails.getRelativePath().getFile(this.baseDestDir);
        this.copyFile(fileVisitDetails, file);
    }

    private void copyFile(FileTreeElement fileTreeElement, File file) {
        boolean bl = fileTreeElement.copyTo(file);
        if (bl) {
            this.didWork = true;
        }
    }
}

