/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.PathNotationParser;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopySpecImpl
implements CopySpec,
ReadableCopySpec {
    private final FileResolver resolver;
    private final Set<Object> sourcePaths;
    private Object destDir;
    private final PatternSet patternSet;
    private final List<ReadableCopySpec> childSpecs;
    private final CopySpecImpl parentSpec;
    private final List<Action<? super FileCopyDetails>> actions = new ArrayList<Action<? super FileCopyDetails>>();
    private Integer dirMode;
    private Integer fileMode;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private PathNotationParser<String> pathNotationParser;

    private CopySpecImpl(FileResolver fileResolver, CopySpecImpl copySpecImpl) {
        this.parentSpec = copySpecImpl;
        this.resolver = fileResolver;
        this.pathNotationParser = new PathNotationParser();
        this.sourcePaths = new LinkedHashSet<Object>();
        this.childSpecs = new ArrayList<ReadableCopySpec>();
        this.patternSet = new PatternSet();
    }

    public CopySpecImpl(FileResolver fileResolver) {
        this(fileResolver, null);
    }

    protected FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecArray) {
        for (CopySpec copySpec : copySpecArray) {
            ReadableCopySpec readableCopySpec;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)((Object)copySpec);
                readableCopySpec = copySpecSource.getRootSpec();
            } else {
                readableCopySpec = (ReadableCopySpec)((Object)copySpec);
            }
            this.childSpecs.add(new WrapperCopySpec(this, readableCopySpec));
        }
        return this;
    }

    @Override
    public CopySpec from(Object ... objectArray) {
        for (Object object : objectArray) {
            this.sourcePaths.add(object);
        }
        return this;
    }

    @Override
    public CopySpec from(Object object, Closure closure) {
        if (closure == null) {
            this.from(object);
            return this;
        }
        CopySpecImpl copySpecImpl = this.addChild();
        copySpecImpl.from(object);
        ConfigureUtil.configure(closure, copySpecImpl);
        return copySpecImpl;
    }

    public CopySpecImpl addFirst() {
        CopySpecImpl copySpecImpl = new CopySpecImpl(this.resolver, this);
        this.childSpecs.add(0, copySpecImpl);
        return copySpecImpl;
    }

    public CopySpecImpl addChild() {
        CopySpecImpl copySpecImpl = new CopySpecImpl(this.resolver, this);
        this.childSpecs.add(copySpecImpl);
        return copySpecImpl;
    }

    public Set<Object> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public FileTree getSource() {
        return this.resolver.resolveFilesAsTree(this.sourcePaths).matching(this.getPatternSet());
    }

    public List<ReadableCopySpec> getAllSpecs() {
        ArrayList<ReadableCopySpec> arrayList = new ArrayList<ReadableCopySpec>();
        arrayList.add(this);
        for (ReadableCopySpec readableCopySpec : this.childSpecs) {
            arrayList.addAll(readableCopySpec.getAllSpecs());
        }
        return arrayList;
    }

    @Override
    public CopySpecImpl into(Object object) {
        this.destDir = object;
        return this;
    }

    @Override
    public CopySpecImpl into(Object object, Closure closure) {
        if (closure == null) {
            this.into(object);
            return this;
        }
        CopySpecImpl copySpecImpl = this.addChild();
        copySpecImpl.into(object);
        ConfigureUtil.configure(closure, copySpecImpl);
        return copySpecImpl;
    }

    @Override
    public RelativePath getDestPath() {
        RelativePath relativePath = this.parentSpec == null ? new RelativePath(false, new String[0]) : this.parentSpec.getDestPath();
        if (this.destDir == null) {
            return relativePath;
        }
        String string = this.resolveToPath(this.destDir);
        if (string.startsWith("/") || string.startsWith(File.separator)) {
            return RelativePath.parse(false, string);
        }
        return RelativePath.parse(false, relativePath, string);
    }

    private String resolveToPath(Object object) {
        return this.pathNotationParser.parseNotation(object);
    }

    public PatternSet getPatternSet() {
        PatternSet patternSet = new PatternSet();
        patternSet.setCaseSensitive(this.isCaseSensitive());
        patternSet.include(this.getAllIncludes());
        patternSet.includeSpecs(this.getAllIncludeSpecs());
        patternSet.exclude(this.getAllExcludes());
        patternSet.excludeSpecs(this.getAllExcludeSpecs());
        return patternSet;
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.caseSensitive != null) {
            return this.caseSensitive;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.isCaseSensitive();
        }
        return true;
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        if (this.includeEmptyDirs != null) {
            return this.includeEmptyDirs;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getIncludeEmptyDirs();
        }
        return true;
    }

    @Override
    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmptyDirs = bl;
    }

    @Override
    public CopySpec include(String ... stringArray) {
        this.patternSet.include(stringArray);
        return this;
    }

    @Override
    public CopySpec include(Iterable<String> iterable) {
        this.patternSet.include(iterable);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> spec) {
        this.patternSet.include(spec);
        return this;
    }

    @Override
    public CopySpec include(Closure closure) {
        this.patternSet.include(closure);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public CopySpec setIncludes(Iterable<String> iterable) {
        this.patternSet.setIncludes((Iterable)iterable);
        return this;
    }

    public List<String> getAllIncludes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.parentSpec != null) {
            arrayList.addAll(this.parentSpec.getAllIncludes());
        }
        arrayList.addAll(this.getIncludes());
        return arrayList;
    }

    public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
        ArrayList<Spec<FileTreeElement>> arrayList = new ArrayList<Spec<FileTreeElement>>();
        if (this.parentSpec != null) {
            arrayList.addAll(this.parentSpec.getAllIncludeSpecs());
        }
        arrayList.addAll(this.patternSet.getIncludeSpecs());
        return arrayList;
    }

    @Override
    public CopySpec exclude(String ... stringArray) {
        this.patternSet.exclude(stringArray);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> iterable) {
        this.patternSet.exclude(iterable);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> spec) {
        this.patternSet.exclude(spec);
        return this;
    }

    @Override
    public CopySpec exclude(Closure closure) {
        this.patternSet.exclude(closure);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public CopySpecImpl setExcludes(Iterable<String> iterable) {
        this.patternSet.setExcludes((Iterable)iterable);
        return this;
    }

    @Override
    public CopySpec rename(String string, String string2) {
        this.actions.add(new RenamingCopyAction(new RegExpNameMapper(string, string2)));
        return this;
    }

    @Override
    public CopySpec rename(Pattern pattern, String string) {
        this.actions.add(new RenamingCopyAction(new RegExpNameMapper(pattern, string)));
        return this;
    }

    @Override
    public CopySpec filter(final Class<? extends FilterReader> clazz) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(clazz);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Closure closure) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(closure);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Map<String, ?> map, final Class<? extends FilterReader> clazz) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(map, clazz);
            }
        });
        return this;
    }

    @Override
    public CopySpec expand(final Map<String, ?> map) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.expand(map);
            }
        });
        return this;
    }

    @Override
    public CopySpec rename(Closure closure) {
        ChainingTransformer<String> chainingTransformer = new ChainingTransformer<String>(String.class);
        chainingTransformer.add(closure);
        this.actions.add(new RenamingCopyAction(chainingTransformer));
        return this;
    }

    @Override
    public Integer getDirMode() {
        if (this.dirMode != null) {
            return this.dirMode;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getDirMode();
        }
        return null;
    }

    @Override
    public Integer getFileMode() {
        if (this.fileMode != null) {
            return this.fileMode;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getFileMode();
        }
        return null;
    }

    @Override
    public CopyProcessingSpec setDirMode(Integer n) {
        this.dirMode = n;
        return this;
    }

    @Override
    public CopyProcessingSpec setFileMode(Integer n) {
        this.fileMode = n;
        return this;
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.actions.add((Action)DefaultGroovyMethods.asType((Closure)closure, Action.class));
        return this;
    }

    public List<String> getAllExcludes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.parentSpec != null) {
            arrayList.addAll(this.parentSpec.getAllExcludes());
        }
        arrayList.addAll(this.getExcludes());
        return arrayList;
    }

    public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
        ArrayList<Spec<FileTreeElement>> arrayList = new ArrayList<Spec<FileTreeElement>>();
        if (this.parentSpec != null) {
            arrayList.addAll(this.parentSpec.getAllExcludeSpecs());
        }
        arrayList.addAll(this.patternSet.getExcludeSpecs());
        return arrayList;
    }

    public List<Action<? super FileCopyDetails>> getAllCopyActions() {
        if (this.parentSpec == null) {
            return this.actions;
        }
        ArrayList<Action<? super FileCopyDetails>> arrayList = new ArrayList<Action<? super FileCopyDetails>>();
        arrayList.addAll(this.parentSpec.getAllCopyActions());
        arrayList.addAll(this.actions);
        return arrayList;
    }

    @Override
    public boolean hasSource() {
        if (!this.sourcePaths.isEmpty()) {
            return true;
        }
        for (ReadableCopySpec readableCopySpec : this.childSpecs) {
            if (!readableCopySpec.hasSource()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperCopySpec
    implements ReadableCopySpec {
        private final ReadableCopySpec root;
        private final ReadableCopySpec spec;

        public WrapperCopySpec(ReadableCopySpec readableCopySpec, ReadableCopySpec readableCopySpec2) {
            this.root = readableCopySpec;
            this.spec = readableCopySpec2;
        }

        @Override
        public RelativePath getDestPath() {
            return this.root.getDestPath().append(this.spec.getDestPath());
        }

        @Override
        public Integer getFileMode() {
            return this.spec.getFileMode();
        }

        @Override
        public Integer getDirMode() {
            return this.spec.getDirMode();
        }

        @Override
        public FileTree getSource() {
            return this.spec.getSource();
        }

        @Override
        public Collection<? extends ReadableCopySpec> getAllSpecs() {
            ArrayList<WrapperCopySpec> arrayList = new ArrayList<WrapperCopySpec>();
            for (ReadableCopySpec readableCopySpec : this.spec.getAllSpecs()) {
                arrayList.add(new WrapperCopySpec(this.root, readableCopySpec));
            }
            return arrayList;
        }

        @Override
        public boolean hasSource() {
            return this.spec.hasSource();
        }

        @Override
        public Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions() {
            return this.spec.getAllCopyActions();
        }

        @Override
        public boolean getIncludeEmptyDirs() {
            return this.spec.getIncludeEmptyDirs();
        }
    }
}

