/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecImpl;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.MappingCopySpecVisitor;
import org.gradle.api.internal.file.copy.NormalizingCopySpecVisitor;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyActionImpl
implements CopyAction,
CopySpecSource {
    private final CopySpecVisitor visitor;
    private final CopySpecImpl root;
    private final CopySpecImpl mainContent;
    private final FileResolver resolver;

    public CopyActionImpl(FileResolver fileResolver, CopySpecVisitor copySpecVisitor) {
        this.resolver = fileResolver;
        this.root = new CopySpecImpl(fileResolver);
        this.mainContent = this.root.addChild();
        this.visitor = new MappingCopySpecVisitor(new NormalizingCopySpecVisitor(copySpecVisitor));
    }

    public FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public CopySpecImpl getRootSpec() {
        return this.root;
    }

    public CopySpecImpl getMainSpec() {
        return this.mainContent;
    }

    public void execute() {
        this.visitor.startVisit(this);
        for (ReadableCopySpec readableCopySpec : this.root.getAllSpecs()) {
            this.visitor.visitSpec(readableCopySpec);
            readableCopySpec.getSource().visit(this.visitor);
        }
        this.visitor.endVisit();
    }

    @Override
    public boolean getDidWork() {
        return this.visitor.getDidWork();
    }

    public FileTree getAllSource() {
        ArrayList<FileTree> arrayList = new ArrayList<FileTree>();
        for (ReadableCopySpec readableCopySpec : this.root.getAllSpecs()) {
            FileTree fileTree = readableCopySpec.getSource();
            arrayList.add(fileTree);
        }
        return this.resolver.resolveFilesAsTree(arrayList);
    }

    public boolean hasSource() {
        return this.root.hasSource();
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.mainContent.eachFile((Action)action);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.mainContent.eachFile(closure);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> iterable) {
        this.mainContent.exclude((Iterable)iterable);
        return this;
    }

    @Override
    public CopySpec exclude(String ... stringArray) {
        this.mainContent.exclude(stringArray);
        return this;
    }

    @Override
    public CopySpec exclude(Closure closure) {
        this.mainContent.exclude(closure);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> spec) {
        this.mainContent.exclude((Spec)spec);
        return this;
    }

    @Override
    public CopySpec expand(Map<String, ?> map) {
        this.mainContent.expand((Map)map);
        return this;
    }

    @Override
    public CopySpec filter(Closure closure) {
        this.mainContent.filter(closure);
        return this;
    }

    @Override
    public CopySpec filter(Class<? extends FilterReader> clazz) {
        this.mainContent.filter((Class)clazz);
        return this;
    }

    @Override
    public CopySpec filter(Map<String, ?> map, Class<? extends FilterReader> clazz) {
        this.mainContent.filter((Map)map, (Class)clazz);
        return this;
    }

    @Override
    public CopySpec from(Object object, Closure closure) {
        return this.mainContent.from(object, closure);
    }

    @Override
    public CopySpec from(Object ... objectArray) {
        this.mainContent.from(objectArray);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.mainContent.getExcludes();
    }

    @Override
    public Set<String> getIncludes() {
        return this.mainContent.getIncludes();
    }

    @Override
    public CopySpec include(Iterable<String> iterable) {
        this.mainContent.include((Iterable)iterable);
        return this;
    }

    @Override
    public CopySpec include(String ... stringArray) {
        this.mainContent.include(stringArray);
        return this;
    }

    @Override
    public CopySpec include(Closure closure) {
        this.mainContent.include(closure);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> spec) {
        this.mainContent.include((Spec)spec);
        return this;
    }

    @Override
    public CopySpec into(Object object) {
        this.mainContent.into(object);
        return this;
    }

    @Override
    public CopySpec into(Object object, Closure closure) {
        return this.mainContent.into(object, closure);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.mainContent.isCaseSensitive();
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.mainContent.getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean bl) {
        this.mainContent.setIncludeEmptyDirs(bl);
    }

    @Override
    public CopySpec rename(Closure closure) {
        this.mainContent.rename(closure);
        return this;
    }

    @Override
    public CopySpec rename(Pattern pattern, String string) {
        this.mainContent.rename(pattern, string);
        return this;
    }

    @Override
    public CopySpec rename(String string, String string2) {
        this.mainContent.rename(string, string2);
        return this;
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.mainContent.setCaseSensitive(bl);
    }

    @Override
    public Integer getDirMode() {
        return this.mainContent.getDirMode();
    }

    @Override
    public CopyProcessingSpec setDirMode(Integer n) {
        this.mainContent.setDirMode(n);
        return this;
    }

    @Override
    public CopySpec setExcludes(Iterable<String> iterable) {
        this.mainContent.setExcludes((Iterable)iterable);
        return this;
    }

    @Override
    public Integer getFileMode() {
        return this.mainContent.getFileMode();
    }

    @Override
    public CopyProcessingSpec setFileMode(Integer n) {
        this.mainContent.setFileMode(n);
        return this;
    }

    @Override
    public CopySpec setIncludes(Iterable<String> iterable) {
        this.mainContent.setIncludes((Iterable)iterable);
        return this;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecArray) {
        this.mainContent.with(copySpecArray);
        return this;
    }
}

