/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final Map<RelativePath, Closure> elements = new LinkedHashMap<RelativePath, Closure>();
    private final Factory<File> tmpDirSource;

    public MapFileTree(final File file) {
        this(new Factory<File>(){

            public File create() {
                return file;
            }
        });
    }

    public MapFileTree(Factory<File> factory) {
        this.tmpDirSource = factory;
    }

    private File getTmpDir() {
        return (File)this.tmpDirSource.create();
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    @Override
    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.getTmpDir());
    }

    @Override
    public void visit(FileVisitor fileVisitor) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        Visit visit = new Visit(fileVisitor, atomicBoolean);
        for (Map.Entry<RelativePath, Closure> entry : this.elements.entrySet()) {
            if (atomicBoolean.get()) break;
            RelativePath relativePath = entry.getKey();
            Closure closure = entry.getValue();
            visit.visit(relativePath, closure);
        }
    }

    public void add(String string, Closure closure) {
        this.elements.put(RelativePath.parse(true, string), closure);
    }

    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private final Closure generator;
        private final long lastModified;
        private final AtomicBoolean stopFlag;
        private File file;

        public FileVisitDetailsImpl(RelativePath relativePath, Closure closure, AtomicBoolean atomicBoolean) {
            this.path = relativePath;
            this.generator = closure;
            this.stopFlag = atomicBoolean;
            this.lastModified = System.currentTimeMillis() / 1000L * 1000L;
        }

        public String getDisplayName() {
            return this.path.toString();
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = this.path.getFile(MapFileTree.this.getTmpDir());
                this.copyTo(this.file);
            }
            return this.file;
        }

        public boolean isDirectory() {
            return !this.path.isFile();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            return this.getFile().length();
        }

        public void copyTo(OutputStream outputStream) {
            this.generator.call((Object)outputStream);
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return this.path;
        }
    }

    private class Visit {
        private final Set<RelativePath> visitedDirs = new LinkedHashSet<RelativePath>();
        private final FileVisitor visitor;
        private final AtomicBoolean stopFlag;

        public Visit(FileVisitor fileVisitor, AtomicBoolean atomicBoolean) {
            this.visitor = fileVisitor;
            this.stopFlag = atomicBoolean;
        }

        private void visitDirs(RelativePath relativePath, FileVisitor fileVisitor) {
            if (relativePath == null || relativePath.getParent() == null || !this.visitedDirs.add(relativePath)) {
                return;
            }
            this.visitDirs(relativePath.getParent(), fileVisitor);
            fileVisitor.visitDir(new FileVisitDetailsImpl(relativePath, null, this.stopFlag));
        }

        public void visit(RelativePath relativePath, Closure closure) {
            this.visitDirs(relativePath.getParent(), this.visitor);
            this.visitor.visitFile(new FileVisitDetailsImpl(relativePath, closure, this.stopFlag));
        }
    }
}

