/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeAdapter
extends AbstractFileTree
implements FileCollectionContainer {
    private final MinimalFileTree tree;

    public FileTreeAdapter(MinimalFileTree minimalFileTree) {
        this.tree = minimalFileTree;
    }

    public MinimalFileTree getTree() {
        return this.tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
        fileCollectionResolveContext.add(this.tree);
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        if (this.tree instanceof FileSystemMirroringFileTree) {
            FileSystemMirroringFileTree fileSystemMirroringFileTree = (FileSystemMirroringFileTree)this.tree;
            if (this.visitAll()) {
                return Collections.singletonList(fileSystemMirroringFileTree.getMirror());
            }
            return Collections.emptyList();
        }
        if (this.tree instanceof LocalFileTree) {
            LocalFileTree localFileTree = (LocalFileTree)this.tree;
            return localFileTree.getLocalContents();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to local file system directories.", this.tree));
    }

    @Override
    public TaskDependency getBuildDependencies() {
        if (this.tree instanceof Buildable) {
            Buildable buildable = (Buildable)((Object)this.tree);
            return buildable.getBuildDependencies();
        }
        return super.getBuildDependencies();
    }

    @Override
    public boolean contains(File file) {
        if (this.tree instanceof RandomAccessFileCollection) {
            RandomAccessFileCollection randomAccessFileCollection = (RandomAccessFileCollection)((Object)this.tree);
            return randomAccessFileCollection.contains(file);
        }
        return super.contains(file);
    }

    @Override
    public FileTree matching(PatternFilterable patternFilterable) {
        if (this.tree instanceof PatternFilterableFileTree) {
            PatternFilterableFileTree patternFilterableFileTree = (PatternFilterableFileTree)this.tree;
            return new FileTreeAdapter(patternFilterableFileTree.filter(patternFilterable));
        }
        return super.matching(patternFilterable);
    }

    @Override
    public FileTree visit(FileVisitor fileVisitor) {
        this.tree.visit(fileVisitor);
        return this;
    }
}

