/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFileTree
implements MinimalFileTree,
PatternFilterableFileTree,
RandomAccessFileCollection,
LocalFileTree,
DirectoryTree {
    private static final Logger LOGGER = Logging.getLogger(DirectoryFileTree.class);
    private final File dir;
    private PatternSet patternSet;
    private boolean depthFirst;

    public DirectoryFileTree(File file) {
        this(file, new PatternSet());
    }

    public DirectoryFileTree(File file, PatternSet patternSet) {
        this.patternSet = patternSet;
        this.dir = GFileUtils.canonicalise(file);
    }

    @Override
    public String getDisplayName() {
        String string = this.patternSet.getIncludes().isEmpty() ? "" : String.format(" include %s", GUtil.toString(this.patternSet.getIncludes()));
        String string2 = this.patternSet.getExcludes().isEmpty() ? "" : String.format(" exclude %s", GUtil.toString(this.patternSet.getExcludes()));
        return String.format("directory '%s'%s%s", this.dir, string, string2);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public File getDir() {
        return this.dir;
    }

    @Override
    public Collection<DirectoryFileTree> getLocalContents() {
        return Collections.singletonList(this);
    }

    @Override
    public DirectoryFileTree filter(PatternFilterable patternFilterable) {
        PatternSet patternSet = this.patternSet.intersect();
        patternSet.copyFrom(patternFilterable);
        return new DirectoryFileTree(this.dir, patternSet);
    }

    @Override
    public boolean contains(File file) {
        String string = this.dir.getAbsolutePath() + File.separator;
        if (!file.getAbsolutePath().startsWith(string)) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RelativePath relativePath = new RelativePath(true, file.getAbsolutePath().substring(string.length()).split(Pattern.quote(File.separator)));
        return this.patternSet.getAsSpec().isSatisfiedBy(new DefaultFileTreeElement(file, relativePath));
    }

    @Override
    public void visit(FileVisitor fileVisitor) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        Spec<FileTreeElement> spec = this.patternSet.getAsSpec();
        if (this.dir.exists()) {
            if (this.dir.isFile()) {
                this.processSingleFile(this.dir, fileVisitor, spec, atomicBoolean);
            } else {
                this.walkDir(this.dir, new RelativePath(false, new String[0]), fileVisitor, spec, atomicBoolean);
            }
        } else {
            LOGGER.info("file or directory '" + this.dir + "', not found");
        }
    }

    private void processSingleFile(File file, FileVisitor fileVisitor, Spec<FileTreeElement> spec, AtomicBoolean atomicBoolean) {
        RelativePath relativePath = new RelativePath(true, file.getName());
        FileVisitDetailsImpl fileVisitDetailsImpl = new FileVisitDetailsImpl(file, relativePath, atomicBoolean);
        if (this.isAllowed(fileVisitDetailsImpl, spec)) {
            fileVisitor.visitFile(fileVisitDetailsImpl);
        }
    }

    private void walkDir(File file, RelativePath relativePath, FileVisitor fileVisitor, Spec<FileTreeElement> spec, AtomicBoolean atomicBoolean) {
        Object object;
        int n;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (file.isDirectory() && !file.canRead()) {
                throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
            }
            throw new GradleException(String.format("Could not list contents of '%s'.", file));
        }
        ArrayList<FileVisitDetailsImpl> arrayList = new ArrayList<FileVisitDetailsImpl>();
        for (n = 0; !atomicBoolean.get() && n < fileArray.length; ++n) {
            object = fileArray[n];
            boolean bl = ((File)object).isFile();
            RelativePath relativePath2 = relativePath.append(bl, ((File)object).getName());
            FileVisitDetailsImpl fileVisitDetailsImpl = new FileVisitDetailsImpl((File)object, relativePath2, atomicBoolean);
            if (!this.isAllowed(fileVisitDetailsImpl, spec)) continue;
            if (bl) {
                fileVisitor.visitFile(fileVisitDetailsImpl);
                continue;
            }
            arrayList.add(fileVisitDetailsImpl);
        }
        for (n = 0; !atomicBoolean.get() && n < arrayList.size(); ++n) {
            object = (FileVisitDetailsImpl)arrayList.get(n);
            if (this.depthFirst) {
                this.walkDir(((DefaultFileTreeElement)object).getFile(), ((DefaultFileTreeElement)object).getRelativePath(), fileVisitor, spec, atomicBoolean);
                fileVisitor.visitDir((FileVisitDetails)object);
                continue;
            }
            fileVisitor.visitDir((FileVisitDetails)object);
            this.walkDir(((DefaultFileTreeElement)object).getFile(), ((DefaultFileTreeElement)object).getRelativePath(), fileVisitor, spec, atomicBoolean);
        }
    }

    boolean isAllowed(FileTreeElement fileTreeElement, Spec<FileTreeElement> spec) {
        return spec.isSatisfiedBy(fileTreeElement);
    }

    public DirectoryFileTree depthFirst() {
        this.depthFirst = true;
        return this;
    }

    private static class FileVisitDetailsImpl
    extends DefaultFileTreeElement
    implements FileVisitDetails {
        private final AtomicBoolean stop;

        private FileVisitDetailsImpl(File file, RelativePath relativePath, AtomicBoolean atomicBoolean) {
            super(file, relativePath);
            this.stop = atomicBoolean;
        }

        public void stopVisiting() {
            this.stop.set(true);
        }
    }
}

