/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionResolveContext
implements ResolvableFileCollectionResolveContext {
    private final FileResolver fileResolver;
    private final List<Object> queue = new LinkedList<Object>();
    private List<Object> addTo = this.queue;
    private final Converter<? extends FileCollection> fileCollectionConverter;
    private final Converter<? extends FileTree> fileTreeConverter;

    public DefaultFileCollectionResolveContext() {
        this(new IdentityFileResolver());
    }

    public DefaultFileCollectionResolveContext(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.fileCollectionConverter = new FileCollectionConverter();
        this.fileTreeConverter = new FileTreeConverter();
    }

    protected DefaultFileCollectionResolveContext(FileResolver fileResolver, Converter<? extends FileCollection> converter, Converter<? extends FileTree> converter2) {
        this.fileResolver = fileResolver;
        this.fileCollectionConverter = converter;
        this.fileTreeConverter = converter2;
    }

    @Override
    public DefaultFileCollectionResolveContext add(Object object) {
        this.addTo.add(object);
        return this;
    }

    @Override
    public DefaultFileCollectionResolveContext push(FileResolver fileResolver) {
        DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = new DefaultFileCollectionResolveContext(fileResolver, this.fileCollectionConverter, this.fileTreeConverter);
        this.add(defaultFileCollectionResolveContext);
        return defaultFileCollectionResolveContext;
    }

    @Override
    public ResolvableFileCollectionResolveContext newContext() {
        return new DefaultFileCollectionResolveContext(this.fileResolver, this.fileCollectionConverter, this.fileTreeConverter);
    }

    @Override
    public List<FileTree> resolveAsFileTrees() {
        return this.doResolve(this.fileTreeConverter);
    }

    @Override
    public List<FileCollection> resolveAsFileCollections() {
        return this.doResolve(this.fileCollectionConverter);
    }

    public List<MinimalFileCollection> resolveAsMinimalFileCollections() {
        return this.doResolve(new MinimalFileCollectionConverter());
    }

    private <T> List<T> doResolve(Converter<? extends T> converter) {
        ArrayList arrayList = new ArrayList();
        while (!this.queue.isEmpty()) {
            Object object;
            Closure closure;
            Object object2 = this.queue.remove(0);
            if (object2 instanceof DefaultFileCollectionResolveContext) {
                closure = (DefaultFileCollectionResolveContext)object2;
                converter.convertInto(closure, arrayList, this.fileResolver);
                continue;
            }
            if (object2 instanceof FileCollectionContainer) {
                closure = (FileCollectionContainer)object2;
                this.resolveNested((FileCollectionContainer)closure);
                continue;
            }
            if (object2 instanceof FileCollection || object2 instanceof MinimalFileCollection) {
                converter.convertInto(object2, arrayList, this.fileResolver);
                continue;
            }
            if (object2 instanceof Task) {
                closure = (Task)object2;
                this.queue.add(0, closure.getOutputs().getFiles());
                continue;
            }
            if (object2 instanceof TaskOutputs) {
                closure = (TaskOutputs)object2;
                this.queue.add(0, closure.getFiles());
                continue;
            }
            if (object2 instanceof Closure) {
                closure = (Closure)object2;
                object = closure.call();
                if (object == null) continue;
                this.queue.add(0, object);
                continue;
            }
            if (object2 instanceof Callable) {
                closure = (Callable)object2;
                try {
                    object = closure.call();
                }
                catch (Exception exception) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                }
                if (object == null) continue;
                this.queue.add(0, object);
                continue;
            }
            if (object2 instanceof Iterable) {
                closure = (Iterable)object2;
                GUtil.addToCollection(this.queue.subList(0, 0), new Iterable[]{closure});
                continue;
            }
            if (object2 instanceof Object[]) {
                closure = (Closure)object2;
                GUtil.addToCollection(this.queue.subList(0, 0), Arrays.asList(closure));
                continue;
            }
            converter.convertInto(object2, arrayList, this.fileResolver);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveNested(FileCollectionContainer fileCollectionContainer) {
        this.addTo = this.queue.subList(0, 0);
        try {
            fileCollectionContainer.resolve(this);
        }
        finally {
            this.addTo = this.queue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinimalFileCollectionConverter
    implements Converter<MinimalFileCollection> {
        private MinimalFileCollectionConverter() {
        }

        @Override
        public void convertInto(Object object, Collection<? super MinimalFileCollection> collection, FileResolver fileResolver) {
            if (object instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = (DefaultFileCollectionResolveContext)object;
                collection.addAll(defaultFileCollectionResolveContext.resolveAsMinimalFileCollections());
            } else if (object instanceof MinimalFileCollection) {
                MinimalFileCollection minimalFileCollection = (MinimalFileCollection)object;
                collection.add(minimalFileCollection);
            } else {
                if (object instanceof FileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to MinimalFileCollection", object.getClass().getSimpleName()));
                }
                if (object instanceof TaskDependency) {
                    return;
                }
                collection.add(new ListBackedFileSet(fileResolver.resolve(object)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTreeConverter
    implements Converter<FileTree> {
        private FileTreeConverter() {
        }

        @Override
        public void convertInto(Object object, Collection<? super FileTree> collection, FileResolver fileResolver) {
            if (object instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = (DefaultFileCollectionResolveContext)object;
                collection.addAll(defaultFileCollectionResolveContext.resolveAsFileTrees());
            } else if (object instanceof FileTree) {
                FileTree fileTree = (FileTree)object;
                collection.add(fileTree);
            } else if (object instanceof MinimalFileTree) {
                MinimalFileTree minimalFileTree = (MinimalFileTree)object;
                collection.add(new FileTreeAdapter(minimalFileTree));
            } else if (object instanceof MinimalFileSet) {
                MinimalFileSet minimalFileSet = (MinimalFileSet)object;
                for (File file : minimalFileSet.getFiles()) {
                    this.convertFileToFileTree(file, collection);
                }
            } else {
                if (object instanceof FileCollection || object instanceof MinimalFileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to FileTree", object.getClass().getSimpleName()));
                }
                if (object instanceof TaskDependency) {
                    return;
                }
                this.convertFileToFileTree(fileResolver.resolve(object), collection);
            }
        }

        private void convertFileToFileTree(File file, Collection<? super FileTree> collection) {
            if (file.isDirectory()) {
                collection.add(new FileTreeAdapter(new DirectoryFileTree(file)));
            } else if (file.isFile()) {
                collection.add(new FileTreeAdapter(new SingletonFileTree(file)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCollectionConverter
    implements Converter<FileCollection> {
        private FileCollectionConverter() {
        }

        @Override
        public void convertInto(Object object, Collection<? super FileCollection> collection, FileResolver fileResolver) {
            if (object instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = (DefaultFileCollectionResolveContext)object;
                collection.addAll(defaultFileCollectionResolveContext.resolveAsFileCollections());
            } else if (object instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)object;
                collection.add(fileCollection);
            } else if (object instanceof MinimalFileTree) {
                MinimalFileTree minimalFileTree = (MinimalFileTree)object;
                collection.add(new FileTreeAdapter(minimalFileTree));
            } else if (object instanceof MinimalFileSet) {
                MinimalFileSet minimalFileSet = (MinimalFileSet)object;
                collection.add(new FileCollectionAdapter(minimalFileSet));
            } else {
                if (object instanceof MinimalFileCollection) {
                    throw new UnsupportedOperationException(String.format("Cannot convert instance of %s to FileTree", object.getClass().getSimpleName()));
                }
                if (object instanceof TaskDependency) {
                    return;
                }
                collection.add(new FileCollectionAdapter(new ListBackedFileSet(fileResolver.resolve(object))));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Converter<T> {
        public void convertInto(Object var1, Collection<? super T> var2, FileResolver var3);
    }
}

