/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.copy.FileCopyActionImpl;
import org.gradle.api.internal.file.copy.FileCopySpecVisitor;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurableFileTree
extends CompositeFileTree
implements ConfigurableFileTree {
    private PatternSet patternSet = new PatternSet();
    private Object dir;
    private final FileResolver resolver;
    private final DefaultTaskDependency buildDependency;

    public DefaultConfigurableFileTree(Object object, FileResolver fileResolver, TaskResolver taskResolver) {
        this(Collections.singletonMap("dir", object), fileResolver, taskResolver);
    }

    public DefaultConfigurableFileTree(Map<String, ?> map, FileResolver fileResolver, TaskResolver taskResolver) {
        this.resolver = fileResolver != null ? fileResolver : new IdentityFileResolver();
        ConfigureUtil.configureByMap(map, this);
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public DefaultConfigurableFileTree setDir(Object object) {
        this.from(object);
        return this;
    }

    @Override
    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    @Override
    public DefaultConfigurableFileTree from(Object object) {
        this.dir = object;
        return this;
    }

    @Override
    public String getDisplayName() {
        return String.format("directory '%s'", this.dir);
    }

    public WorkResult copy(Closure closure) {
        FileCopyActionImpl fileCopyActionImpl = new FileCopyActionImpl(this.resolver, new FileCopySpecVisitor());
        fileCopyActionImpl.from(this);
        ConfigureUtil.configure(closure, fileCopyActionImpl);
        fileCopyActionImpl.execute();
        return fileCopyActionImpl;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public DefaultConfigurableFileTree setIncludes(Iterable<String> iterable) {
        this.patternSet.setIncludes((Iterable)iterable);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultConfigurableFileTree setExcludes(Iterable<String> iterable) {
        this.patternSet.setExcludes((Iterable)iterable);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(String ... stringArray) {
        this.patternSet.include(stringArray);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Iterable<String> iterable) {
        this.patternSet.include(iterable);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Closure closure) {
        this.patternSet.include(closure);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Spec<FileTreeElement> spec) {
        this.patternSet.include(spec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(String ... stringArray) {
        this.patternSet.exclude(stringArray);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Iterable<String> iterable) {
        this.patternSet.exclude(iterable);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> spec) {
        this.patternSet.exclude(spec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Closure closure) {
        this.patternSet.exclude(closure);
        return this;
    }

    @Override
    public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
        File file = this.getDir();
        if (!this.buildDependency.getValues().isEmpty()) {
            fileCollectionResolveContext.add(this.buildDependency);
        }
        fileCollectionResolveContext.add(new DirectoryFileTree(file, this.patternSet));
    }

    @Override
    public ConfigurableFileTree builtBy(Object ... objectArray) {
        this.buildDependency.add(objectArray);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileTree setBuiltBy(Iterable<?> iterable) {
        this.buildDependency.setValues(iterable);
        return this;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependency;
    }
}

