/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection {
    private final Set<Object> files;
    private final String displayName;
    private final FileResolver resolver;
    private final DefaultTaskDependency buildDependency;

    public DefaultConfigurableFileCollection(FileResolver fileResolver, TaskResolver taskResolver, Object ... objectArray) {
        this("file collection", fileResolver, taskResolver, objectArray);
    }

    public DefaultConfigurableFileCollection(String string, FileResolver fileResolver, TaskResolver taskResolver, Object ... objectArray) {
        this.displayName = string;
        this.resolver = fileResolver;
        this.files = new LinkedHashSet<Object>(Arrays.asList(objectArray));
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<Object> getFrom() {
        return this.files;
    }

    @Override
    public void setFrom(Iterable<?> iterable) {
        this.files.clear();
        this.files.add(iterable);
    }

    @Override
    public void setFrom(Object ... objectArray) {
        this.files.clear();
        GUtil.addToCollection(this.files, Arrays.asList(objectArray));
    }

    @Override
    public ConfigurableFileCollection from(Object ... objectArray) {
        GUtil.addToCollection(this.files, Arrays.asList(objectArray));
        return this;
    }

    @Override
    public ConfigurableFileCollection builtBy(Object ... objectArray) {
        this.buildDependency.add(objectArray);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileCollection setBuiltBy(Iterable<?> iterable) {
        this.buildDependency.setValues(iterable);
        return this;
    }

    @Override
    public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
        FileCollectionResolveContext fileCollectionResolveContext2 = fileCollectionResolveContext.push(this.resolver);
        if (!this.buildDependency.getValues().isEmpty()) {
            fileCollectionResolveContext2.add(this.buildDependency);
        }
        fileCollectionResolveContext2.add(this.files);
    }
}

