/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.EmptyFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDependenciesOnlyFileCollectionResolveContext
extends DefaultFileCollectionResolveContext {
    public BuildDependenciesOnlyFileCollectionResolveContext() {
        super(new IdentityFileResolver(), new BuildableFileTreeInternalConverter(), new BuildableFileTreeInternalConverter());
    }

    public List<? extends Buildable> resolveAsBuildables() {
        return this.resolveAsFileCollections();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildableFileTreeInternalConverter
    implements DefaultFileCollectionResolveContext.Converter<FileTree> {
        private BuildableFileTreeInternalConverter() {
        }

        @Override
        public void convertInto(Object object, Collection<? super FileTree> collection, FileResolver fileResolver) {
            if (object instanceof DefaultFileCollectionResolveContext) {
                DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = (DefaultFileCollectionResolveContext)object;
                collection.addAll(defaultFileCollectionResolveContext.resolveAsFileTrees());
            } else if (object instanceof Buildable) {
                Buildable buildable = (Buildable)object;
                collection.add(new FileTreeAdapter(new EmptyFileTree(buildable.getBuildDependencies())));
            } else if (object instanceof TaskDependency) {
                TaskDependency taskDependency = (TaskDependency)object;
                collection.add(new FileTreeAdapter(new EmptyFileTree(taskDependency)));
            }
        }
    }
}

