/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.internal.file.archive.compression.Compressor;
import org.gradle.api.internal.resources.URIBuilder;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceException;

public class GzipArchiver
implements ReadableResource {
    private ReadableResource resource;
    private URI uri;

    public GzipArchiver(ReadableResource readableResource) {
        assert (readableResource != null);
        this.resource = readableResource;
        this.uri = new URIBuilder(readableResource.getURI()).schemePrefix("gzip:").build();
    }

    public static Compressor getCompressor() {
        return new Compressor(){

            public OutputStream compress(File file) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    return new GZIPOutputStream(fileOutputStream);
                }
                catch (Exception exception) {
                    String string = String.format("Unable to create gzip output stream for file %s.", file);
                    throw new RuntimeException(string, exception);
                }
            }
        };
    }

    public InputStream read() {
        InputStream inputStream = this.resource.read();
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (Exception exception) {
            String string = String.format("Unable to create gzip input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(string, exception);
        }
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }
}

