/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.gradle.api.internal.file.archive.compression.Compressor;
import org.gradle.api.internal.resources.URIBuilder;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceException;

public class Bzip2Archiver
implements ReadableResource {
    private final ReadableResource resource;
    private final URI uri;

    public Bzip2Archiver(ReadableResource readableResource) {
        assert (readableResource != null);
        this.resource = readableResource;
        this.uri = new URIBuilder(readableResource.getURI()).schemePrefix("bzip2:").build();
    }

    public static Compressor getCompressor() {
        return new Compressor(){

            public OutputStream compress(File file) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(66);
                    ((OutputStream)fileOutputStream).write(90);
                    return new CBZip2OutputStream((OutputStream)fileOutputStream);
                }
                catch (Exception exception) {
                    String string = String.format("Unable to create bzip2 output stream for file %s", file);
                    throw new RuntimeException(string, exception);
                }
            }
        };
    }

    public InputStream read() {
        InputStream inputStream = this.resource.read();
        try {
            byte[] byArray = new byte[2];
            inputStream.read(byArray);
            return new CBZip2InputStream(inputStream);
        }
        catch (Exception exception) {
            String string = String.format("Unable to create bzip2 input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(string, exception);
        }
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }
}

