/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.hash.HashUtil;

public class ZipFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final File zipFile;
    private final File tmpDir;

    public ZipFileTree(File file, File file2) {
        this.zipFile = file;
        String string = String.format("%s_%s", file.getName(), HashUtil.createCompactMD5(file.getAbsolutePath()));
        this.tmpDir = new File(file2, string);
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.zipFile);
    }

    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor fileVisitor) {
        if (!this.zipFile.exists()) {
            DeprecationLogger.nagUserWith(String.format("The specified zip file %s does not exist and will be silently ignored. This behaviour has been deprecated and will cause an error in the next version of Gradle.", this.getDisplayName()));
            return;
        }
        if (!this.zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        try {
            ZipFile zipFile = new ZipFile(this.zipFile);
            try {
                Object object;
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                Enumeration enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    object = (ZipEntry)enumeration.nextElement();
                    treeMap.put(object.getName(), object);
                }
                object = treeMap.values().iterator();
                while (!atomicBoolean.get() && object.hasNext()) {
                    ZipEntry zipEntry = (ZipEntry)object.next();
                    if (zipEntry.isDirectory()) {
                        fileVisitor.visitDir(new DetailsImpl(zipEntry, zipFile, atomicBoolean));
                        continue;
                    }
                    fileVisitor.visitFile(new DetailsImpl(zipEntry, zipFile, atomicBoolean));
                }
            }
            finally {
                zipFile.close();
            }
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), exception);
        }
    }

    private class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(ZipEntry zipEntry, ZipFile zipFile, AtomicBoolean atomicBoolean) {
            this.entry = zipEntry;
            this.zip = zipFile;
            this.stopFlag = atomicBoolean;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", ZipFileTree.this.zipFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(ZipFileTree.this.tmpDir, this.entry.getName());
                this.copyTo(this.file);
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        public int getMode() {
            int n = this.entry.getUnixMode() & 0x1FF;
            if (n == 0) {
                n = this.isDirectory() ? 493 : 420;
            }
            return n;
        }
    }
}

