/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.copy.ArchiveCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;

public class ZipCopySpecVisitor
extends EmptyCopySpecVisitor {
    private ZipOutputStream zipOutStr;
    private File zipFile;

    public void startVisit(CopyAction copyAction) {
        ArchiveCopyAction archiveCopyAction = (ArchiveCopyAction)copyAction;
        this.zipFile = archiveCopyAction.getArchivePath();
        try {
            this.zipOutStr = new ZipOutputStream(this.zipFile);
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not create ZIP '%s'.", this.zipFile), exception);
        }
    }

    public void endVisit() {
        try {
            this.zipOutStr.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            this.zipOutStr = null;
        }
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        try {
            ZipEntry zipEntry = new ZipEntry(fileVisitDetails.getRelativePath().getPathString());
            zipEntry.setMethod(8);
            zipEntry.setTime(fileVisitDetails.getLastModified());
            zipEntry.setUnixMode(0x8000 | fileVisitDetails.getMode());
            this.zipOutStr.putNextEntry(zipEntry);
            fileVisitDetails.copyTo((OutputStream)this.zipOutStr);
            this.zipOutStr.closeEntry();
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileVisitDetails, this.zipFile), exception);
        }
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        try {
            ZipEntry zipEntry = new ZipEntry(fileVisitDetails.getRelativePath().getPathString() + '/');
            zipEntry.setTime(fileVisitDetails.getLastModified());
            zipEntry.setUnixMode(0x4000 | fileVisitDetails.getMode());
            this.zipOutStr.putNextEntry(zipEntry);
            this.zipOutStr.closeEntry();
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileVisitDetails, this.zipFile), exception);
        }
    }

    public boolean getDidWork() {
        return true;
    }
}

