/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.archive.TarCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;

public class TarCopySpecVisitor
extends EmptyCopySpecVisitor {
    private TarOutputStream tarOutStr;
    private File tarFile;

    public void startVisit(CopyAction copyAction) {
        TarCopyAction tarCopyAction = (TarCopyAction)copyAction;
        try {
            this.tarFile = tarCopyAction.getArchivePath();
            OutputStream outputStream = tarCopyAction.getCompressor().compress(this.tarFile);
            this.tarOutStr = new TarOutputStream(outputStream);
            this.tarOutStr.setLongFileMode(2);
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), exception);
        }
    }

    public void endVisit() {
        try {
            this.tarOutStr.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            this.tarOutStr = null;
        }
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        try {
            TarEntry tarEntry = new TarEntry(fileVisitDetails.getRelativePath().getPathString());
            tarEntry.setModTime(fileVisitDetails.getLastModified());
            tarEntry.setSize(fileVisitDetails.getSize());
            tarEntry.setMode(0x8000 | fileVisitDetails.getMode());
            this.tarOutStr.putNextEntry(tarEntry);
            fileVisitDetails.copyTo((OutputStream)this.tarOutStr);
            this.tarOutStr.closeEntry();
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileVisitDetails, this.tarFile), exception);
        }
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        try {
            TarEntry tarEntry = new TarEntry(fileVisitDetails.getRelativePath().getPathString() + '/');
            tarEntry.setModTime(fileVisitDetails.getLastModified());
            tarEntry.setMode(0x4000 | fileVisitDetails.getMode());
            this.tarOutStr.putNextEntry(tarEntry);
            this.tarOutStr.closeEntry();
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileVisitDetails, this.tarFile), exception);
        }
    }

    public boolean getDidWork() {
        return true;
    }
}

