/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFileTree
extends CompositeFileTree {
    private final Set<FileTree> sourceTrees;
    private final String displayName;

    public UnionFileTree(FileTree ... fileTreeArray) {
        this("file tree", Arrays.asList(fileTreeArray));
    }

    public UnionFileTree(String string, FileTree ... fileTreeArray) {
        this(string, Arrays.asList(fileTreeArray));
    }

    public UnionFileTree(String string, Collection<? extends FileTree> collection) {
        this.displayName = string;
        this.sourceTrees = new LinkedHashSet<FileTree>(collection);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
        fileCollectionResolveContext.add(this.sourceTrees);
    }

    @Override
    public UnionFileTree add(FileCollection fileCollection) {
        if (!(fileCollection instanceof FileTree)) {
            throw new UnsupportedOperationException(String.format("Can only add FileTree instances to %s.", this.getDisplayName()));
        }
        this.sourceTrees.add((FileTree)fileCollection);
        return this;
    }
}

