/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileSource;
import org.gradle.internal.SystemProperties;
import org.gradle.util.GFileUtils;

public class TmpDirTemporaryFileProvider
extends DefaultTemporaryFileProvider {
    private final List<File> createdFiles = new ArrayList<File>();

    public TmpDirTemporaryFileProvider() {
        super(new FileSource(){

            public File get() {
                return GFileUtils.canonicalise(new File(SystemProperties.getJavaIoTmpDir()));
            }
        });
    }

    public File createTemporaryFile(@Nullable String string, @Nullable String string2, String ... stringArray) {
        return this.deleteLater(super.createTemporaryFile(string, string2, stringArray));
    }

    public File createTemporaryDirectory(@Nullable String string, @Nullable String string2, String ... stringArray) {
        return this.deleteLater(super.createTemporaryDirectory(string, string2, stringArray));
    }

    public void deleteAllCreated() {
        for (File file : this.createdFiles) {
            GFileUtils.deleteQuietly(file);
        }
    }

    private File deleteLater(File file) {
        this.createdFiles.add(file);
        return file;
    }
}

