/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.tasks.bundling.Compression;

public class MaybeCompressedFileResource
implements ReadableResource {
    private final ReadableResource resource;

    public MaybeCompressedFileResource(ReadableResource readableResource) {
        String string = FilenameUtils.getExtension((String)readableResource.getURI().toString());
        this.resource = Compression.BZIP2.getSupportedExtensions().contains(string) ? new Bzip2Archiver(readableResource) : (Compression.GZIP.getSupportedExtensions().contains(string) ? new GzipArchiver(readableResource) : readableResource);
    }

    public InputStream read() throws MissingResourceException {
        return this.resource.read();
    }

    public ReadableResource getResource() {
        return this.resource;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }
}

