/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOrUriNotationParser<T extends Serializable>
implements NotationParser<T> {
    private static final Pattern URI_SCHEME = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-\\.]*:.+");
    private static final Pattern ENCODED_URI = Pattern.compile("%([0-9a-fA-F]{2})");
    private final FileSystem fileSystem;

    public FileOrUriNotationParser(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void describe(Collection<String> collection) {
        collection.add("File, URI, URL or CharSequence is supported");
    }

    @Override
    public T parseNotation(Object object) throws UnsupportedNotationException {
        if (object instanceof File) {
            return (T)((Serializable)object);
        }
        if (object instanceof URL) {
            try {
                object = ((URL)object).toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new UncheckedIOException(uRISyntaxException);
            }
        }
        if (object instanceof URI) {
            URI uRI = (URI)object;
            if (uRI.getScheme().equals("file")) {
                return (T)new File(uRI.getPath());
            }
            return (T)uRI;
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            if (string.startsWith("file:")) {
                return (T)new File(this.uriDecode(string.substring(5)));
            }
            for (File file : File.listRoots()) {
                String string2 = file.getAbsolutePath();
                String string3 = string;
                if (!this.fileSystem.isCaseSensitive()) {
                    string2 = string2.toLowerCase();
                    string3 = string3.toLowerCase();
                }
                if (!string3.startsWith(string2) && !string3.startsWith(string2.replace(File.separatorChar, '/'))) continue;
                return (T)new File(string);
            }
            if (URI_SCHEME.matcher(string).matches()) {
                try {
                    return (T)new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new UncheckedIOException(uRISyntaxException);
                }
            }
        } else {
            DeprecationLogger.nagUserWith(String.format("Converting class %s to File using toString() Method.  This has been deprecated and will be removed in the next version of Gradle. Please use java.io.File, java.lang.String, java.net.URL, or java.net.URI instead.", object.getClass().getName()));
        }
        return (T)new File(object.toString());
    }

    private String uriDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = ENCODED_URI.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, String.valueOf((char)Integer.parseInt(string2, 16)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

