/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileSource;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

public class DefaultTemporaryFileProvider
implements TemporaryFileProvider {
    private final FileSource baseDir;

    public DefaultTemporaryFileProvider(FileSource fileSource) {
        this.baseDir = fileSource;
    }

    public File newTemporaryFile(String ... stringArray) {
        return GFileUtils.canonicalise(new File(this.baseDir.get(), GUtil.join(stringArray, "/")));
    }

    public File createTemporaryFile(String string, @Nullable String string2, String ... stringArray) {
        File file = new File(this.baseDir.get(), GUtil.join(stringArray, "/"));
        GFileUtils.createDirectory(file);
        try {
            return File.createTempFile(string, string2, file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException.getMessage(), iOException);
        }
    }

    public File createTemporaryDirectory(@Nullable String string, @Nullable String string2, String ... stringArray) {
        File file = new File(this.baseDir.get(), GUtil.join(stringArray, "/"));
        GFileUtils.createDirectory(file);
        try {
            File file2 = File.createTempFile("gradle", "projectDir", file);
            file2.delete();
            file2.mkdir();
            return file2;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException.getMessage(), iOException);
        }
    }
}

