/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileResolver fileResolver;
    private final PatternSet patterns = new PatternSet();
    private final PatternSet filter = new PatternSet();

    public DefaultSourceDirectorySet(String string, String string2, FileResolver fileResolver) {
        this.name = string;
        this.displayName = string2;
        this.fileResolver = fileResolver;
    }

    public DefaultSourceDirectorySet(String string, FileResolver fileResolver) {
        this(string, string, fileResolver);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<File> getSrcDirs() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (DirectoryTree directoryTree : this.getSrcDirTrees()) {
            linkedHashSet.add(directoryTree.getDir());
        }
        return linkedHashSet;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    @Override
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    @Override
    public PatternFilterable setIncludes(Iterable<String> iterable) {
        this.patterns.setIncludes((Iterable)iterable);
        return this;
    }

    @Override
    public PatternFilterable setExcludes(Iterable<String> iterable) {
        this.patterns.setExcludes((Iterable)iterable);
        return this;
    }

    @Override
    public PatternFilterable include(String ... stringArray) {
        this.patterns.include(stringArray);
        return this;
    }

    @Override
    public PatternFilterable include(Iterable<String> iterable) {
        this.patterns.include(iterable);
        return this;
    }

    @Override
    public PatternFilterable include(Spec<FileTreeElement> spec) {
        this.patterns.include(spec);
        return this;
    }

    @Override
    public PatternFilterable include(Closure closure) {
        this.patterns.include(closure);
        return this;
    }

    @Override
    public PatternFilterable exclude(Iterable<String> iterable) {
        this.patterns.exclude(iterable);
        return this;
    }

    @Override
    public PatternFilterable exclude(String ... stringArray) {
        this.patterns.exclude(stringArray);
        return this;
    }

    @Override
    public PatternFilterable exclude(Spec<FileTreeElement> spec) {
        this.patterns.exclude(spec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Closure closure) {
        this.patterns.exclude(closure);
        return this;
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    @Override
    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> linkedHashMap = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree directoryTree : this.doGetSrcDirTrees()) {
            if (linkedHashMap.containsKey(directoryTree.getDir())) continue;
            linkedHashMap.put(directoryTree.getDir(), directoryTree);
        }
        return new LinkedHashSet<DirectoryTree>(linkedHashMap.values());
    }

    private Set<DirectoryTree> doGetSrcDirTrees() {
        LinkedHashSet<DirectoryTree> linkedHashSet = new LinkedHashSet<DirectoryTree>();
        for (Object object : this.source) {
            Object object2;
            if (object instanceof SourceDirectorySet) {
                object2 = (SourceDirectorySet)object;
                linkedHashSet.addAll(object2.getSrcDirTrees());
                continue;
            }
            object2 = this.fileResolver.resolve(object);
            if (((File)object2).exists() && !((File)object2).isDirectory()) {
                throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", object2));
            }
            linkedHashSet.add(new DirectoryFileTree((File)object2, this.patterns));
        }
        return linkedHashSet;
    }

    @Override
    public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
        for (DirectoryTree directoryTree : this.getSrcDirTrees()) {
            if (!directoryTree.getDir().isDirectory()) continue;
            fileCollectionResolveContext.add(((DirectoryFileTree)directoryTree).filter(this.filter));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SourceDirectorySet srcDir(Object object) {
        this.source.add(object);
        return this;
    }

    @Override
    public SourceDirectorySet srcDirs(Object ... objectArray) {
        for (Object object : objectArray) {
            this.source.add(object);
        }
        return this;
    }

    @Override
    public SourceDirectorySet setSrcDirs(Iterable<?> iterable) {
        this.source.clear();
        GUtil.addToCollection(this.source, iterable);
        return this;
    }

    @Override
    public SourceDirectorySet source(SourceDirectorySet sourceDirectorySet) {
        this.source.add(sourceDirectorySet);
        return this;
    }
}

