/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteAction;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.archive.TarFileTree;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.copy.CopyActionImpl;
import org.gradle.api.internal.file.copy.CopySpecImpl;
import org.gradle.api.internal.file.copy.DeleteActionImpl;
import org.gradle.api.internal.file.copy.FileCopyActionImpl;
import org.gradle.api.internal.file.copy.FileCopySpecVisitor;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileOperations
implements FileOperations,
ProcessOperations {
    private final FileResolver fileResolver;
    private final TaskResolver taskResolver;
    private final TemporaryFileProvider temporaryFileProvider;
    private DeleteAction deleteAction;
    private final DefaultResourceHandler resourceHandler;

    public DefaultFileOperations(FileResolver fileResolver, TaskResolver taskResolver, TemporaryFileProvider temporaryFileProvider) {
        this.fileResolver = fileResolver;
        this.taskResolver = taskResolver;
        this.temporaryFileProvider = temporaryFileProvider;
        this.deleteAction = new DeleteActionImpl(fileResolver);
        this.resourceHandler = new DefaultResourceHandler(fileResolver);
    }

    @Override
    public File file(Object object) {
        return this.fileResolver.resolve(object);
    }

    @Override
    public File file(Object object, PathValidation pathValidation) {
        return this.fileResolver.resolve(object, pathValidation);
    }

    @Override
    public URI uri(Object object) {
        return this.fileResolver.resolveUri(object);
    }

    @Override
    public ConfigurableFileCollection files(Object ... objectArray) {
        return new DefaultConfigurableFileCollection(this.fileResolver, this.taskResolver, objectArray);
    }

    @Override
    public ConfigurableFileCollection files(Object object, Closure closure) {
        return ConfigureUtil.configure(closure, this.files(object));
    }

    @Override
    public ConfigurableFileTree fileTree(Object object) {
        return new DefaultConfigurableFileTree(object, this.fileResolver, this.taskResolver);
    }

    @Override
    public ConfigurableFileTree fileTree(Object object, Closure closure) {
        return ConfigureUtil.configure(closure, this.fileTree(object));
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> map) {
        return new DefaultConfigurableFileTree(map, this.fileResolver, this.taskResolver);
    }

    @Override
    public ConfigurableFileTree fileTree(Closure closure) {
        return ConfigureUtil.configure(closure, new DefaultConfigurableFileTree((Object)Collections.emptyMap(), this.fileResolver, this.taskResolver));
    }

    @Override
    public FileTree zipTree(Object object) {
        return new FileTreeAdapter(new ZipFileTree(this.file(object), this.getExpandDir()));
    }

    @Override
    public FileTree tarTree(Object object) {
        ReadableResource readableResource = this.getResources().maybeCompressed(object);
        TarFileTree tarFileTree = new TarFileTree(readableResource, this.getExpandDir());
        return new FileTreeAdapter(tarFileTree);
    }

    private File getExpandDir() {
        return this.temporaryFileProvider.newTemporaryFile("expandedArchives");
    }

    @Override
    public String relativePath(Object object) {
        return this.fileResolver.resolveAsRelativePath(object);
    }

    @Override
    public File mkdir(Object object) {
        File file = this.fileResolver.resolve(object);
        if (file.isFile()) {
            throw new InvalidUserDataException(String.format("Can't create directory. The path=%s points to an existing file.", object));
        }
        file.mkdirs();
        return file;
    }

    @Override
    public boolean delete(Object ... objectArray) {
        return this.deleteAction.delete(objectArray);
    }

    @Override
    public WorkResult copy(Closure closure) {
        CopyActionImpl copyActionImpl = ConfigureUtil.configure(closure, new FileCopyActionImpl(this.fileResolver, new FileCopySpecVisitor()));
        copyActionImpl.execute();
        return copyActionImpl;
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return ConfigureUtil.configure(closure, new CopySpecImpl(this.fileResolver));
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(DeleteAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        JavaExecAction javaExecAction = ConfigureUtil.configure(closure, new DefaultJavaExecAction(this.fileResolver));
        return javaExecAction.execute();
    }

    @Override
    public ExecResult exec(Closure closure) {
        ExecAction execAction = ConfigureUtil.configure(closure, new DefaultExecAction(this.fileResolver));
        return execAction.execute();
    }

    @Override
    public DefaultResourceHandler getResources() {
        return this.resourceHandler;
    }
}

