/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileCollection
extends AbstractFileCollection
implements FileCollectionContainer {
    @Override
    public Set<File> getFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            linkedHashSet.addAll(fileCollection.getFiles());
        }
        return linkedHashSet;
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object object, String string) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(object, string, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> arrayList = new ArrayList<DirectoryFileTree>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            AbstractFileCollection abstractFileCollection = (AbstractFileCollection)fileCollection;
            arrayList.addAll(abstractFileCollection.getAsFileTrees());
        }
        return arrayList;
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
                ResolvableFileCollectionResolveContext resolvableFileCollectionResolveContext = fileCollectionResolveContext.newContext();
                CompositeFileCollection.this.resolve(resolvableFileCollectionResolveContext);
                fileCollectionResolveContext.add(resolvableFileCollectionResolveContext.resolveAsFileTrees());
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(final Spec<? super File> spec) {
        return new CompositeFileCollection(){

            public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    fileCollectionResolveContext.add(fileCollection.filter(spec));
                }
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }

            public TaskDependency getBuildDependencies() {
                return CompositeFileCollection.this.getBuildDependencies();
            }
        };
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext taskDependencyResolveContext) {
                CompositeFileCollection.this.addDependencies(taskDependencyResolveContext);
            }
        };
    }

    protected void addDependencies(TaskDependencyResolveContext taskDependencyResolveContext) {
        BuildDependenciesOnlyFileCollectionResolveContext buildDependenciesOnlyFileCollectionResolveContext = new BuildDependenciesOnlyFileCollectionResolveContext();
        this.resolve(buildDependenciesOnlyFileCollectionResolveContext);
        for (Buildable buildable : buildDependenciesOnlyFileCollectionResolveContext.resolveAsBuildables()) {
            taskDependencyResolveContext.add(buildable);
        }
    }

    protected List<? extends FileCollection> getSourceCollections() {
        DefaultFileCollectionResolveContext defaultFileCollectionResolveContext = new DefaultFileCollectionResolveContext();
        this.resolve(defaultFileCollectionResolveContext);
        return defaultFileCollectionResolveContext.resolveAsFileCollections();
    }

    @Override
    public abstract void resolve(FileCollectionResolveContext var1);
}

