/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.util.GUtil;

public class BaseDirFileResolver
extends AbstractFileResolver {
    private final File baseDir;

    public BaseDirFileResolver(FileSystem fileSystem, File file) {
        super(fileSystem);
        assert (file.isAbsolute()) : String.format("base dir '%s' is not an absolute file.", file);
        this.baseDir = file;
    }

    public String resolveAsRelativePath(Object object) {
        int n;
        List<String> list = Arrays.asList(StringUtils.split((String)this.baseDir.getAbsolutePath(), (String)("/" + File.separator)));
        File file = this.resolve(object);
        List<String> list2 = new ArrayList<String>(Arrays.asList(StringUtils.split((String)file.getAbsolutePath(), (String)("/" + File.separator))));
        int n2 = Math.min(list.size(), list2.size());
        for (n = 0; n < n2 && list.get(n).equals(list2.get(n)); ++n) {
        }
        list = list.subList(n, list.size());
        list2 = list2.subList(n, list2.size());
        for (int i = 0; i < list.size(); ++i) {
            list2.add(0, "..");
        }
        if (list2.isEmpty()) {
            return ".";
        }
        return GUtil.join(list2, File.separator);
    }

    protected File doResolve(Object object) {
        if (!GUtil.isTrue(object) || !GUtil.isTrue(this.baseDir)) {
            throw new IllegalArgumentException(String.format("Neither path nor baseDir may be null or empty string. path='%s' basedir='%s'", object, this.baseDir));
        }
        File file = this.convertObjectToFile(object);
        if (!file.isAbsolute()) {
            file = new File(this.baseDir, file.getPath());
        }
        return file;
    }
}

