/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;

public abstract class AbstractFileTreeElement
implements FileTreeElement {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.getRelativePath().getLastName();
    }

    public String getPath() {
        return this.getRelativePath().getPathString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream outputStream) {
        try {
            InputStream inputStream = this.open();
            try {
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public boolean copyTo(File file) {
        this.validateTimeStamps();
        try {
            file.getParentFile().mkdirs();
            if (this.isDirectory()) {
                file.mkdirs();
            } else {
                this.copyFile(file);
            }
            FileSystems.getDefault().chmod(file, this.getMode());
            return true;
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not copy %s to '%s'.", this.getDisplayName(), file), exception);
        }
    }

    private void validateTimeStamps() {
        long l = this.getLastModified();
        if (l < 0L) {
            throw new GradleException(String.format("Invalid Timestamp %s for '%s'.", l, this.getDisplayName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.copyTo(fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public int getMode() {
        return this.isDirectory() ? 493 : 420;
    }
}

