/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AntFileTreeBuilder;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileTree
extends AbstractFileCollection
implements FileTree {
    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                linkedHashSet.add(fileVisitDetails.getFile());
            }
        });
        return linkedHashSet;
    }

    @Override
    public boolean isEmpty() {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                atomicBoolean.set(true);
                fileVisitDetails.stopVisiting();
            }
        });
        return !atomicBoolean.get();
    }

    @Override
    public FileTree matching(Closure closure) {
        PatternSet patternSet = new PatternSet();
        ConfigureUtil.configure(closure, patternSet);
        return this.matching(patternSet);
    }

    @Override
    public FileTree matching(PatternFilterable patternFilterable) {
        PatternSet patternSet = new PatternSet();
        patternSet.copyFrom(patternFilterable);
        return new FilteredFileTree(this, patternSet.getAsSpec());
    }

    public Map<String, File> getAsMap() {
        final LinkedHashMap<String, File> linkedHashMap = new LinkedHashMap<String, File>();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                linkedHashMap.put(fileVisitDetails.getRelativePath().getPathString(), fileVisitDetails.getFile());
            }
        });
        return linkedHashMap;
    }

    @Override
    protected void addAsResourceCollection(Object object, String string) {
        new AntFileTreeBuilder(this.getAsMap()).addToAntBuilder(object, string);
    }

    protected boolean visitAll() {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
                fileVisitDetails.getFile();
                atomicBoolean.set(true);
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                fileVisitDetails.getFile();
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, fileTree);
    }

    @Override
    public FileTree visit(Closure closure) {
        return this.visit((FileVisitor)DefaultGroovyMethods.asType((Closure)closure, FileVisitor.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredFileTree
    extends AbstractFileTree {
        private final AbstractFileTree fileTree;
        private final Spec<FileTreeElement> spec;

        public FilteredFileTree(AbstractFileTree abstractFileTree, Spec<FileTreeElement> spec) {
            this.fileTree = abstractFileTree;
            this.spec = spec;
        }

        @Override
        public String getDisplayName() {
            return this.fileTree.getDisplayName();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return this.fileTree.getBuildDependencies();
        }

        @Override
        public FileTree visit(final FileVisitor fileVisitor) {
            this.fileTree.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                    if (FilteredFileTree.this.spec.isSatisfiedBy(fileVisitDetails)) {
                        fileVisitor.visitDir(fileVisitDetails);
                    }
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    if (FilteredFileTree.this.spec.isSatisfiedBy(fileVisitDetails)) {
                        fileVisitor.visitFile(fileVisitDetails);
                    }
                }
            });
            return this;
        }
    }
}

