/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileOrUriNotationParser;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileResource;
import org.gradle.api.internal.file.FileSource;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.resources.ReadableResource;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.GUtil;

public abstract class AbstractFileResolver
implements FileResolver {
    private final FileSystem fileSystem;
    private FileOrUriNotationParser fileNotationParser;

    protected AbstractFileResolver(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.fileNotationParser = new FileOrUriNotationParser(fileSystem);
    }

    public FileResolver withBaseDir(Object object) {
        return new BaseDirFileResolver(this.fileSystem, this.resolve(object));
    }

    public File resolve(Object object) {
        return this.resolve(object, PathValidation.NONE);
    }

    public File resolve(Object object, PathValidation pathValidation) {
        File file = this.doResolve(object);
        file = this.normalise(file);
        this.validate(file, pathValidation);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private File normalise(File file) {
        try {
            void var4_8;
            assert (file.isAbsolute()) : String.format("Cannot normalize a relative file: '%s'", file);
            if (OperatingSystem.current().isWindows()) {
                return file.getCanonicalFile();
            }
            String[] stringArray = file.getPath().split(String.format("[/%s]", Pattern.quote(File.separator)));
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                if (string.equals("..")) {
                    if (arrayList.isEmpty()) continue;
                    arrayList.remove(arrayList.size() - 1);
                    continue;
                }
                if (string.equals(".") || string.length() <= 0) continue;
                arrayList.add(string);
            }
            String string = GUtil.join(arrayList, File.separator);
            int n = File.listRoots()[0].getPath().startsWith(File.separator) ? 1 : 0;
            if (n != 0) {
                String string2 = File.separator + string;
            }
            File file2 = new File((String)var4_8);
            if (this.fileSystem.isCaseSensitive()) {
                return file2;
            }
            File file3 = file2.getCanonicalFile();
            if (file2.getPath().equalsIgnoreCase(file3.getPath())) {
                return file3;
            }
            File file4 = File.listRoots()[0];
            for (int i = 0; i < arrayList.size(); ++i) {
                File file5 = this.findChild(file4, (String)arrayList.get(i));
                if (file5 == null) {
                    file4 = new File(file4, GUtil.join(arrayList.subList(i, arrayList.size()), File.separator));
                    break;
                }
                file4 = file5;
            }
            return file4;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(String.format("Could not normalize path for file '%s'.", file), iOException);
        }
    }

    private File findChild(File file, String string) throws IOException {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return new File(file, string2);
        }
        return new File(file, string);
    }

    public FileSource resolveLater(final Object object) {
        return new FileSource(){

            public File get() {
                return AbstractFileResolver.this.resolve(object);
            }
        };
    }

    public URI resolveUri(Object object) {
        return this.convertObjectToURI(object);
    }

    protected abstract File doResolve(Object var1);

    protected URI convertObjectToURI(Object object) {
        Object object2 = this.unpack(object);
        Object object3 = this.fileNotationParser.parseNotation(object2);
        if (object3 instanceof File) {
            return this.resolve(object3).toURI();
        }
        return (URI)object3;
    }

    protected File convertObjectToFile(Object object) {
        Object object2 = this.unpack(object);
        if (object2 == null) {
            return null;
        }
        Object object3 = this.fileNotationParser.parseNotation(object2);
        if (object3 instanceof File) {
            return (File)object3;
        }
        throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", object3));
    }

    private Object unpack(Object object) {
        Object object2 = object;
        while (object2 != null) {
            if (object2 instanceof Closure) {
                object2 = ((Closure)object2).call();
                continue;
            }
            if (object2 instanceof Callable) {
                try {
                    object2 = ((Callable)object2).call();
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (object2 instanceof FileSource) {
                return ((FileSource)object2).get();
            }
            return object2;
        }
        return null;
    }

    protected void validate(File file, PathValidation pathValidation) {
        switch (pathValidation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }

    public FileCollection resolveFiles(Object ... objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof FileCollection) {
            return (FileCollection)objectArray[0];
        }
        return new DefaultConfigurableFileCollection(this, null, objectArray);
    }

    public FileTree resolveFilesAsTree(Object ... objectArray) {
        return this.resolveFiles(objectArray).getAsFileTree();
    }

    public ReadableResource resolveResource(Object object) {
        if (object instanceof ReadableResource) {
            return (ReadableResource)object;
        }
        return new FileResource(this.resolve(object));
    }
}

