/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollection
implements FileCollection,
MinimalFileSet {
    @Override
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public File getSingleFile() throws IllegalStateException {
        Set<File> set = this.getFiles();
        if (set.isEmpty()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        if (set.size() != 1) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains %d files.", this.getDisplayName(), set.size()));
        }
        return (File)set.iterator().next();
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @Override
    public String getAsPath() {
        return GUtil.join(this.getFiles(), File.pathSeparator);
    }

    @Override
    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    @Override
    public FileCollection plus(FileCollection fileCollection) {
        return new UnionFileCollection(this, fileCollection);
    }

    @Override
    public FileCollection minus(final FileCollection fileCollection) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                linkedHashSet.removeAll(fileCollection.getFiles());
                return linkedHashSet;
            }
        };
    }

    @Override
    public FileCollection add(FileCollection fileCollection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("%s does not allow modification.", this.getCapDisplayName()));
    }

    @Override
    public void addToAntBuilder(Object object, String string, FileCollection.AntType antType) {
        if (antType == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(object, string);
        } else if (antType == FileCollection.AntType.FileSet) {
            this.addAsFileSet(object, string);
        } else {
            this.addAsMatchingTask(object, string);
        }
    }

    protected void addAsMatchingTask(Object object, String string) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(object, string);
    }

    protected void addAsFileSet(Object object, String string) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(object, string);
    }

    protected void addAsResourceCollection(Object object, String string) {
        new AntFileCollectionBuilder(this).addToAntBuilder(object, string);
    }

    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> arrayList = new ArrayList<DirectoryFileTree>();
        for (File file : this.getFiles()) {
            if (!file.isFile()) continue;
            PatternSet patternSet = new PatternSet();
            patternSet.include(file.getName());
            arrayList.add(new DirectoryFileTree(file.getParentFile(), patternSet));
        }
        return arrayList;
    }

    @Override
    public Object addToAntBuilder(Object object, String string) {
        this.addToAntBuilder(object, string, FileCollection.AntType.ResourceCollection);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileCollection stopExecutionIfEmpty() {
        if (this.isEmpty()) {
            throw new StopExecutionException(String.format("%s does not contain any files.", this.getCapDisplayName()));
        }
        return this;
    }

    @Override
    public Object asType(Class<?> clazz) throws UnsupportedOperationException {
        if (clazz.isAssignableFrom(Set.class)) {
            return this.getFiles();
        }
        if (clazz.isAssignableFrom(List.class)) {
            return new ArrayList<File>(this.getFiles());
        }
        if (clazz.isAssignableFrom(File[].class)) {
            Set<File> set = this.getFiles();
            return set.toArray(new File[set.size()]);
        }
        if (clazz.isAssignableFrom(File.class)) {
            return this.getSingleFile();
        }
        if (clazz.isAssignableFrom(FileCollection.class)) {
            return this;
        }
        if (clazz.isAssignableFrom(FileTree.class)) {
            return this.getAsFileTree();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to type %s, as this type is not supported.", this.getDisplayName(), clazz.getSimpleName()));
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new DefaultTaskDependency();
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void resolve(FileCollectionResolveContext fileCollectionResolveContext) {
                ResolvableFileCollectionResolveContext resolvableFileCollectionResolveContext = fileCollectionResolveContext.newContext();
                resolvableFileCollectionResolveContext.add(AbstractFileCollection.this);
                fileCollectionResolveContext.add(resolvableFileCollectionResolveContext.resolveAsFileTrees());
            }

            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(Closure closure) {
        return this.filter(Specs.convertClosureToSpec(closure));
    }

    @Override
    public FileCollection filter(final Spec<? super File> spec) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                return CollectionUtils.filter(AbstractFileCollection.this, new LinkedHashSet(), spec);
            }
        };
    }

    protected String getCapDisplayName() {
        return StringUtils.capitalize((String)this.getDisplayName());
    }
}

