/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.concurrent;

import org.gradle.api.internal.concurrent.Synchronizer;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedServiceRegistry
implements ServiceRegistry {
    private final Synchronizer synchronizer = new Synchronizer();
    private final ServiceRegistry delegate;

    public SynchronizedServiceRegistry(ServiceRegistry serviceRegistry) {
        this.delegate = serviceRegistry;
    }

    public <T> T get(final Class<T> clazz) throws UnknownServiceException {
        return this.synchronizer.synchronize(new Factory<T>(){

            public T create() {
                return SynchronizedServiceRegistry.this.delegate.get(clazz);
            }
        });
    }

    public <T> Factory<T> getFactory(final Class<T> clazz) throws UnknownServiceException {
        return (Factory)this.synchronizer.synchronize(new Factory<Factory<T>>(){

            public Factory<T> create() {
                return SynchronizedServiceRegistry.this.delegate.getFactory(clazz);
            }
        });
    }

    public <T> T newInstance(final Class<T> clazz) throws UnknownServiceException {
        return this.synchronizer.synchronize(new Factory<T>(){

            public T create() {
                return SynchronizedServiceRegistry.this.delegate.newInstance(clazz);
            }
        });
    }
}

