/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.FilteredCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredList<T, S extends T>
extends FilteredCollection<T, S>
implements List<S> {
    public FilteredList(Collection<T> collection, CollectionFilter<S> collectionFilter) {
        super(collection, collectionFilter);
    }

    @Override
    public void add(int n, S s) {
        throw new UnsupportedOperationException(String.format("Cannot add '%s' to '%s' as it is a filtered collection", s, this));
    }

    @Override
    public boolean addAll(int n, Collection<? extends S> collection) {
        throw new UnsupportedOperationException(String.format("Cannot add all from '%s' to '%s' as it is a filtered collection", collection, this));
    }

    @Override
    public S get(int n) {
        int n2 = 0;
        for (Object e : this.collection) {
            Object t = this.filter.filter(e);
            if (t == null) continue;
            if (n2 == n) {
                return (S)t;
            }
            ++n2;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public S set(int n, S s) {
        throw new UnsupportedOperationException(String.format("Cannot set '%s' in '%s' as it is a filtered collection", s, this));
    }

    @Override
    public S remove(int n) {
        throw new UnsupportedOperationException(String.format("Cannot remove element from '%s' as it is a filtered collection", this));
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        for (Object e : this.collection) {
            Object t = this.filter.filter(e);
            if (t == null) continue;
            if (t.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = 0;
        int n2 = -1;
        for (Object e : this.collection) {
            Object t = this.filter.filter(e);
            if (t == null) continue;
            if (t.equals(object)) {
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    @Override
    public ListIterator<S> listIterator() {
        return new FilteredListIterator(this.iterator());
    }

    @Override
    public ListIterator<S> listIterator(int n) {
        ListIterator<S> listIterator = this.listIterator();
        for (int i = 0; i < n; ++i) {
            listIterator.next();
        }
        return listIterator;
    }

    @Override
    public List<S> subList(int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredListIterator<T>
    implements ListIterator<T> {
        private final Iterator<T> iterator;
        private int nextIndex;

        public FilteredListIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public T next() {
            ++this.nextIndex;
            return this.iterator.next();
        }

        @Override
        public T previous() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

