/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gradle.api.internal.collections.CollectionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredCollection<T, S extends T>
implements Collection<S> {
    protected final Collection<T> collection;
    protected final CollectionFilter<S> filter;

    public FilteredCollection(Collection<T> collection, CollectionFilter<S> collectionFilter) {
        this.collection = collection;
        this.filter = collectionFilter;
    }

    @Override
    public boolean add(S s) {
        throw new UnsupportedOperationException(String.format("Cannot add '%s' to '%s' as it is a filtered collection", s, this));
    }

    @Override
    public boolean addAll(Collection<? extends S> collection) {
        throw new UnsupportedOperationException(String.format("Cannot add all from '%s' to '%s' as it is a filtered collection", collection, this));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(String.format("Cannot clear '%s' as it is a filtered collection", this));
    }

    protected boolean accept(Object object) {
        return this.filter.filter(object) != null;
    }

    @Override
    public boolean contains(Object object) {
        return this.collection.contains(object) && this.accept(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (this.collection.containsAll(collection)) {
            for (Object obj : collection) {
                if (this.accept(obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        if (this.collection.isEmpty()) {
            return true;
        }
        for (T t : this.collection) {
            if (!this.accept(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<S> iterator() {
        return new FilteringIterator<T, S>(this.collection.iterator(), this.filter);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(String.format("Cannot remove '%s' from '%s' as it is a filtered collection", object, this));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(String.format("Cannot remove all of '%s' from '%s' as it is a filtered collection", collection, this));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(String.format("Cannot retain all of '%s' from '%s' as it is a filtered collection", collection, this));
    }

    @Override
    public int size() {
        int n = 0;
        for (T t : this.collection) {
            if (!this.accept(t)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        for (T t : this.collection) {
            if (!this.accept(t)) continue;
            objectArray[n++] = t;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.toArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilteringIterator<T, S extends T>
    implements Iterator<S> {
        private final CollectionFilter<S> filter;
        private final Iterator<T> iterator;
        private S next;

        public FilteringIterator(Iterator<T> iterator, CollectionFilter<S> collectionFilter) {
            this.iterator = iterator;
            this.filter = collectionFilter;
            this.next = this.findNext();
        }

        private S findNext() {
            while (this.iterator.hasNext()) {
                T t = this.iterator.next();
                S s = this.filter.filter(t);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public S next() {
            if (this.next != null) {
                S s = this.next;
                this.next = this.findNext();
                return s;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }
    }
}

