/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFilter<T>
implements Spec<T> {
    private Class<? extends T> type;
    private Spec<? super T> spec;

    public CollectionFilter(Class<T> clazz) {
        this(clazz, Specs.satisfyAll());
    }

    public CollectionFilter(Class<? extends T> clazz, Spec<? super T> spec) {
        this.type = clazz;
        this.spec = spec;
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public T filter(Object object) {
        if (!this.type.isInstance(object)) {
            return null;
        }
        T t = this.type.cast(object);
        if (this.spec.isSatisfiedBy(t)) {
            return t;
        }
        return null;
    }

    @Override
    public boolean isSatisfiedBy(T t) {
        return this.filter(t) != null;
    }
}

