/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import org.gradle.api.Action;
import org.gradle.api.internal.FilteredAction;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.specs.Specs;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEventRegister<T> {
    private final ActionBroadcast<T> addActions;
    private final ActionBroadcast<T> removeActions;

    public CollectionEventRegister() {
        this(new ActionBroadcast(), new ActionBroadcast());
    }

    public CollectionEventRegister(ActionBroadcast<T> actionBroadcast, ActionBroadcast<T> actionBroadcast2) {
        this.addActions = actionBroadcast;
        this.removeActions = actionBroadcast2;
    }

    public Action<T> getAddAction() {
        return this.addActions;
    }

    public Action<T> getRemoveAction() {
        return this.removeActions;
    }

    public Action<? super T> registerAddAction(Action<? super T> action) {
        this.addActions.add(action);
        return action;
    }

    public Action<? super T> registerRemoveAction(Action<? super T> action) {
        this.removeActions.add(action);
        return action;
    }

    public <S extends T> CollectionEventRegister<S> filtered(CollectionFilter<S> collectionFilter) {
        return new FilteringCollectionEventRegister<S>(collectionFilter, this.addActions, this.removeActions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringCollectionEventRegister<S>
    extends CollectionEventRegister<S> {
        private final CollectionFilter<S> filter;

        public FilteringCollectionEventRegister(CollectionFilter<S> collectionFilter, ActionBroadcast<S> actionBroadcast, ActionBroadcast<S> actionBroadcast2) {
            super(actionBroadcast, actionBroadcast2);
            this.filter = collectionFilter;
        }

        @Override
        public Action<? super S> registerAddAction(Action<? super S> action) {
            return super.registerAddAction(new FilteredAction<S>(this.filter, action));
        }

        @Override
        public Action<? super S> registerRemoveAction(Action<? super S> action) {
            return super.registerRemoveAction(new FilteredAction<S>(this.filter, action));
        }

        @Override
        public <K extends S> CollectionEventRegister<K> filtered(CollectionFilter<K> collectionFilter) {
            return super.filtered(new CollectionFilter<K>(collectionFilter.getType(), Specs.and(collectionFilter, this.filter)));
        }
    }
}

