/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestUtil {
    private static final String[] EMPTY = new String[0];

    public static String createManifestClasspath(File file, Collection<File> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (File file2 : collection) {
            String string = ManifestUtil.constructRelativeClasspathUri(file, file2);
            arrayList.add(string);
        }
        return GUtil.join(arrayList, " ");
    }

    private static String constructRelativeClasspathUri(File file, File file2) {
        URI uRI = file.getParentFile().toURI();
        URI uRI2 = file2.toURI();
        URI uRI3 = uRI.relativize(uRI2);
        return uRI3.getRawPath();
    }

    public static List<URI> parseManifestClasspath(File file) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (String string : ManifestUtil.readManifestClasspathString(file)) {
            try {
                URI uRI = new URI(string);
                uRI = file.toURI().resolve(uRI);
                arrayList.add(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new UncheckedIOException(uRISyntaxException);
            }
        }
        return arrayList;
    }

    private static String[] readManifestClasspathString(File file) {
        try {
            Manifest manifest = ManifestUtil.findManifest(file);
            if (manifest == null) {
                return EMPTY;
            }
            String string = manifest.getMainAttributes().getValue("Class-Path");
            if (string == null || string.trim().length() == 0) {
                return EMPTY;
            }
            return string.split(" ");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest findManifest(File file) throws IOException {
        JarFile jarFile;
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            jarFile = new JarFile(file);
        }
        catch (ZipException zipException) {
            return null;
        }
        try {
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        finally {
            jarFile.close();
        }
    }
}

