/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.ManifestUtil;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.DefaultClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectiveClassPath
extends DefaultClassPath {
    public EffectiveClassPath(ClassLoader classLoader) {
        super(EffectiveClassPath.findAvailableClasspathFiles(classLoader));
    }

    private static List<File> findAvailableClasspathFiles(ClassLoader classLoader) {
        List<URL> list = ClasspathUtil.getClasspath(classLoader);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (URL uRL : list) {
            if (!uRL.getProtocol().equals("file")) continue;
            try {
                File file = new File(uRL.toURI());
                EffectiveClassPath.addClasspathFile(file, arrayList);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new UncheckedIOException(uRISyntaxException);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            for (String string : System.getProperty("java.class.path").split(File.pathSeparator)) {
                EffectiveClassPath.addClasspathFile(new File(string), arrayList);
            }
        }
        return arrayList;
    }

    private static void addClasspathFile(File file, List<File> list) {
        if (file.exists() && !list.contains(file)) {
            list.add(file);
            EffectiveClassPath.addManifestClasspathFiles(file, list);
        }
    }

    private static void addManifestClasspathFiles(File file, List<File> list) {
        List<URI> list2 = ManifestUtil.parseManifestClasspath(file);
        for (URI uRI : list2) {
            EffectiveClassPath.addClasspathFile(new File(uRI), list);
        }
    }
}

