/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginModuleRegistry
implements PluginModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginModuleRegistry.class);
    private final ModuleRegistry moduleRegistry;

    public DefaultPluginModuleRegistry(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public Set<Module> getPluginModules() {
        LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
        Properties properties = this.loadPluginProperties();
        for (String string : properties.getProperty("plugins").split(",")) {
            try {
                linkedHashSet.add(this.moduleRegistry.getModule(string));
            }
            catch (UnknownModuleException unknownModuleException) {
                LOGGER.debug("Cannot find module for plugin {}. Ignoring.", (Object)string);
            }
        }
        return linkedHashSet;
    }

    private Properties loadPluginProperties() {
        return GUtil.loadProperties(this.getClass().getResource("/gradle-plugins.properties"));
    }
}

