/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.util.ClassPath;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.DefaultClassPath;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleRegistry
implements ModuleRegistry,
GradleDistributionLocator {
    private final ClassLoader classLoader;
    private final File distDir;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final List<File> classpath = new ArrayList<File>();
    private final Map<String, File> classpathJars = new LinkedHashMap<String, File>();
    private final List<File> libDirs = new ArrayList<File>();

    public DefaultModuleRegistry() {
        this(DefaultModuleRegistry.class.getClassLoader(), DefaultModuleRegistry.findDistDir());
    }

    DefaultModuleRegistry(ClassLoader classLoader, File file) {
        this.classLoader = classLoader;
        this.distDir = file;
        for (File file2 : new EffectiveClassPath(classLoader).getAsFiles()) {
            this.classpath.add(file2);
            if (!file2.isFile() || this.classpathJars.containsKey(file2.getName())) continue;
            this.classpathJars.put(file2.getName(), file2);
        }
        if (file != null) {
            this.libDirs.add(new File(file, "lib"));
            this.libDirs.add(new File(file, "lib/plugins"));
        }
    }

    private static File findDistDir() {
        File file = ClasspathUtil.getClasspathForClass(DefaultModuleRegistry.class);
        if (file.isFile()) {
            File file2 = file.getParentFile();
            if (!file2.getName().equals("lib") || !new File(file2, "plugins").isDirectory()) {
                return null;
            }
            return file2.getParentFile();
        }
        return null;
    }

    public Set<File> getFullClasspath() {
        return new LinkedHashSet<File>(this.classpath);
    }

    @Override
    public File getGradleHome() {
        return this.distDir;
    }

    @Override
    public Module getExternalModule(String string) {
        File file = this.findExternalJar(string);
        return new DefaultModule(string, Collections.singleton(file), Collections.<File>emptySet(), Collections.<Module>emptySet());
    }

    @Override
    public Module getModule(String string) {
        Module module = this.modules.get(string);
        if (module == null) {
            module = this.loadModule(string);
            this.modules.put(string, module);
        }
        return module;
    }

    private Module loadModule(String string) {
        File file = this.findModuleJar(string);
        if (file != null) {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            linkedHashSet.add(file);
            Properties properties = this.loadModuleProperties(string, file);
            return this.module(string, properties, linkedHashSet);
        }
        String string2 = String.format("%s-classpath.properties", string);
        URL uRL = this.classLoader.getResource(string2);
        if (uRL != null) {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            this.findImplementationClasspath(string, linkedHashSet);
            linkedHashSet.add(ClasspathUtil.getClasspathForResource(uRL, string2));
            Properties properties = GUtil.loadProperties(uRL);
            return this.module(string, properties, linkedHashSet);
        }
        if (this.distDir == null) {
            throw new UnknownModuleException(String.format("Cannot locate classpath manifest for module '%s' in classpath.", string));
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", string, this.distDir));
    }

    private Module module(String string, Properties properties, Set<File> set) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        String string2 = properties.getProperty("runtime");
        for (String string3 : this.split(string2)) {
            linkedHashSet.add(this.findDependencyJar(string, string3));
        }
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        String string4 = properties.getProperty("projects");
        for (String string5 : this.split(string4)) {
            linkedHashSet2.add(this.getModule(string5));
        }
        return new DefaultModule(string, set, linkedHashSet, linkedHashSet2);
    }

    private String[] split(String string) {
        if (string == null) {
            return new String[0];
        }
        if ((string = string.trim()).length() == 0) {
            return new String[0];
        }
        return string.split(",");
    }

    private void findImplementationClasspath(String string, Collection<File> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("gradle-(.+)").matcher(string);
        matcher.matches();
        String string2 = matcher.group(1);
        String string3 = this.toCamelCase(string2);
        arrayList.add(String.format("/out/production/%s", string3).replace('/', File.separatorChar));
        arrayList.add(String.format("/%s/bin", string2).replace('/', File.separatorChar));
        arrayList.add(String.format("/%s/src/main/resources", string2).replace('/', File.separatorChar));
        arrayList.add(String.format("/%s/build/classes/main", string2).replace('/', File.separatorChar));
        arrayList.add(String.format("/%s/build/resources/main", string2).replace('/', File.separatorChar));
        for (File file : this.classpath) {
            if (!file.isDirectory()) continue;
            for (String string4 : arrayList) {
                if (!file.getAbsolutePath().endsWith(string4)) continue;
                collection.add(file);
            }
        }
    }

    private String toCamelCase(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = Pattern.compile("-([^-])").matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
            stringBuffer.append(matcher.group(1).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadModuleProperties(String string, File file) {
        Properties properties;
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(String.format("%s-classpath.properties", string));
            properties = GUtil.loadProperties(zipFile.getInputStream(zipEntry));
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        zipFile.close();
        return properties;
    }

    private File findModuleJar(String string) {
        Pattern pattern = Pattern.compile(Pattern.quote(string) + "-\\d.+\\.jar");
        for (File file : this.libDirs) {
            for (File file2 : file.listFiles()) {
                if (!pattern.matcher(file2.getName()).matches()) continue;
                return file2;
            }
        }
        return null;
    }

    private File findExternalJar(String string) {
        Pattern pattern = Pattern.compile(Pattern.quote(string) + "-\\d.+\\.jar");
        for (File file : this.classpath) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            return file;
        }
        for (File file : this.libDirs) {
            for (File file2 : file.listFiles()) {
                if (!pattern.matcher(file2.getName()).matches()) continue;
                return file2;
            }
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", string, this.distDir));
    }

    private File findDependencyJar(String string, String string2) {
        File file = this.classpathJars.get(string2);
        if (file != null) {
            return file;
        }
        if (this.distDir == null) {
            throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath.", string2, string));
        }
        for (File file2 : this.libDirs) {
            file = new File(file2, string2);
            if (!file.isFile()) continue;
            return file;
        }
        throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath or distribution directory '%s'", string2, string, this.distDir));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultModule
    implements Module {
        private final String name;
        private final ClassPath implementationClasspath;
        private final ClassPath runtimeClasspath;
        private final Set<Module> modules;
        private final ClassPath classpath;

        public DefaultModule(String string, Set<File> set, Set<File> set2, Set<Module> set3) {
            this.name = string;
            this.implementationClasspath = new DefaultClassPath(set);
            this.runtimeClasspath = new DefaultClassPath(set2);
            this.modules = set3;
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            linkedHashSet.addAll(set);
            linkedHashSet.addAll(set2);
            this.classpath = new DefaultClassPath(linkedHashSet);
        }

        public String toString() {
            return String.format("module '%s'", this.name);
        }

        @Override
        public Set<Module> getRequiredModules() {
            return this.modules;
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public ClassPath getRuntimeClasspath() {
            return this.runtimeClasspath;
        }

        @Override
        public ClassPath getClasspath() {
            return this.classpath;
        }

        @Override
        public Set<Module> getAllRequiredModules() {
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            linkedHashSet.add(this);
            for (Module module : this.modules) {
                linkedHashSet.addAll(module.getAllRequiredModules());
            }
            return linkedHashSet;
        }
    }
}

