/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import org.apache.commons.lang.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final Logger LOGGER = Logging.getLogger(ShortCircuitTaskArtifactStateRepository.class);
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, TaskArtifactStateRepository taskArtifactStateRepository) {
        this.startParameter = startParameter;
        this.repository = taskArtifactStateRepository;
    }

    public TaskArtifactState getStateFor(TaskInternal taskInternal) {
        if (taskInternal.getOutputs().getHasOutput()) {
            return new ShortCircuitArtifactState(taskInternal, this.repository.getStateFor(taskInternal));
        }
        LOGGER.info(String.format("%s has not declared any outputs, assuming that it is out-of-date.", StringUtils.capitalize((String)taskInternal.toString())));
        return new NoHistoryArtifactState();
    }

    private class ShortCircuitArtifactState
    implements TaskArtifactState {
        private final TaskInternal task;
        private final TaskArtifactState state;

        public ShortCircuitArtifactState(TaskInternal taskInternal, TaskArtifactState taskArtifactState) {
            this.task = taskInternal;
            this.state = taskArtifactState;
        }

        public boolean isUpToDate() {
            return !ShortCircuitTaskArtifactStateRepository.this.startParameter.isRerunTasks() && this.task.getOutputs().getUpToDateSpec().isSatisfiedBy(this.task) && this.state.isUpToDate();
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this.state.getExecutionHistory();
        }

        public void beforeTask() {
            this.state.beforeTask();
        }

        public void afterTask() {
            this.state.afterTask();
        }

        public void finished() {
            this.state.finished();
        }
    }

    private static class NoHistoryArtifactState
    implements TaskArtifactState,
    TaskExecutionHistory {
        private NoHistoryArtifactState() {
        }

        public boolean isUpToDate() {
            return false;
        }

        public void beforeTask() {
        }

        public void afterTask() {
        }

        public void finished() {
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        public FileCollection getOutputFiles() {
            throw new UnsupportedOperationException();
        }
    }
}

