/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.MapMergeChangeListener;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;
import org.gradle.util.IdGenerator;
import org.gradle.util.NoOpChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesSnapshotter
implements FileSnapshotter {
    private final FileSnapshotter snapshotter;
    private final IdGenerator<Long> idGenerator;
    private final PersistentIndexedCache<String, Long> dirIdentiferCache;

    public OutputFilesSnapshotter(FileSnapshotter fileSnapshotter, IdGenerator<Long> idGenerator, TaskArtifactStateCacheAccess taskArtifactStateCacheAccess) {
        this.snapshotter = fileSnapshotter;
        this.idGenerator = idGenerator;
        this.dirIdentiferCache = taskArtifactStateCacheAccess.createCache("outputFileStates", String.class, Long.class);
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesSnapshot(new HashMap<String, Long>(), this.snapshotter.emptySnapshot());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection fileCollection) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (File file : fileCollection) {
            Long l;
            if (file.exists()) {
                l = this.dirIdentiferCache.get(file.getAbsolutePath());
                if (l == null) {
                    l = this.idGenerator.generateId();
                    this.dirIdentiferCache.put(file.getAbsolutePath(), l);
                }
            } else {
                this.dirIdentiferCache.remove(file.getAbsolutePath());
                l = null;
            }
            hashMap.put(file.getAbsolutePath(), l);
        }
        return new OutputFilesSnapshot(hashMap, this.snapshotter.snapshot(fileCollection));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFilesDiff
    implements FileCollectionSnapshot.Diff {
        private final Map<String, Long> newFileIds;
        private final Map<String, Long> oldFileIds;
        private final FileCollectionSnapshot.Diff filesDiff;

        public OutputFilesDiff(Map<String, Long> map, Map<String, Long> map2, FileCollectionSnapshot.Diff diff) {
            this.newFileIds = map;
            this.oldFileIds = map2;
            this.filesDiff = diff;
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot fileCollectionSnapshot, ChangeListener<FileCollectionSnapshot.Merge> changeListener) {
            OutputFilesSnapshot outputFilesSnapshot = (OutputFilesSnapshot)fileCollectionSnapshot;
            HashMap hashMap = new HashMap(outputFilesSnapshot.rootFileIds);
            DiffUtil.diff(this.newFileIds, this.oldFileIds, new MapMergeChangeListener(new NoOpChangeListener<FileCollectionSnapshot.Merge>(), hashMap));
            return new OutputFilesSnapshot(this.newFileIds, this.filesDiff.applyTo(outputFilesSnapshot.filesSnapshot, changeListener));
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot fileCollectionSnapshot) {
            return this.applyTo(fileCollectionSnapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFilesSnapshot
    implements FileCollectionSnapshot {
        private final Map<String, Long> rootFileIds;
        private final FileCollectionSnapshot filesSnapshot;

        public OutputFilesSnapshot(Map<String, Long> map, FileCollectionSnapshot fileCollectionSnapshot) {
            this.rootFileIds = map;
            this.filesSnapshot = fileCollectionSnapshot;
        }

        @Override
        public FileCollection getFiles() {
            return this.filesSnapshot.getFiles();
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot fileCollectionSnapshot) {
            OutputFilesSnapshot outputFilesSnapshot = (OutputFilesSnapshot)fileCollectionSnapshot;
            return new OutputFilesDiff(this.rootFileIds, outputFilesSnapshot.rootFileIds, this.filesSnapshot.changesSince(outputFilesSnapshot.filesSnapshot));
        }

        @Override
        public void changesSince(FileCollectionSnapshot fileCollectionSnapshot, final ChangeListener<File> changeListener) {
            final OutputFilesSnapshot outputFilesSnapshot = (OutputFilesSnapshot)fileCollectionSnapshot;
            DiffUtil.diff(this.rootFileIds, outputFilesSnapshot.rootFileIds, new ChangeListener<Map.Entry<String, Long>>(){

                @Override
                public void added(Map.Entry<String, Long> entry) {
                    changeListener.added(new File(entry.getKey()));
                }

                @Override
                public void removed(Map.Entry<String, Long> entry) {
                    changeListener.removed(new File(entry.getKey()));
                }

                @Override
                public void changed(Map.Entry<String, Long> entry) {
                    if (outputFilesSnapshot.rootFileIds.get(entry.getKey()) == null) {
                        return;
                    }
                    changeListener.changed(new File(entry.getKey()));
                }
            });
            this.filesSnapshot.changesSince(outputFilesSnapshot.filesSnapshot, new ChangeListener<File>(){

                @Override
                public void added(File file) {
                }

                @Override
                public void removed(File file) {
                    changeListener.removed(file);
                }

                @Override
                public void changed(File file) {
                    changeListener.changed(file);
                }
            });
        }
    }
}

