/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;

public class OutputFilesChangedUpToDateRule
implements UpToDateRule {
    private final FileSnapshotter outputFilesSnapshotter;

    public OutputFilesChangedUpToDateRule(FileSnapshotter fileSnapshotter) {
        this.outputFilesSnapshotter = fileSnapshotter;
    }

    public UpToDateRule.TaskUpToDateState create(final TaskInternal taskInternal, final TaskExecution taskExecution, final TaskExecution taskExecution2) {
        final FileCollectionSnapshot fileCollectionSnapshot = this.outputFilesSnapshotter.snapshot(taskInternal.getOutputs().getFiles());
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> collection) {
                if (taskExecution.getOutputFilesSnapshot() == null) {
                    collection.add(String.format("Output file history is not available for %s.", taskInternal));
                    return;
                }
                fileCollectionSnapshot.changesSince(taskExecution.getOutputFilesSnapshot(), new ChangeListener<File>(){

                    @Override
                    public void added(File file) {
                        collection.add(String.format("Output file '%s' has been added for %s.", file, taskInternal));
                    }

                    @Override
                    public void removed(File file) {
                        collection.add(String.format("Output file %s has been removed for %s.", file.getAbsolutePath(), taskInternal));
                    }

                    @Override
                    public void changed(File file) {
                        collection.add(String.format("Output file %s for %s has changed.", file.getAbsolutePath(), taskInternal));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
                FileCollectionSnapshot fileCollectionSnapshot4 = taskExecution == null || taskExecution.getOutputFilesSnapshot() == null ? OutputFilesChangedUpToDateRule.this.outputFilesSnapshotter.emptySnapshot() : taskExecution.getOutputFilesSnapshot();
                FileCollectionSnapshot fileCollectionSnapshot2 = fileCollectionSnapshot.changesSince(fileCollectionSnapshot4).applyTo(fileCollectionSnapshot4, new ChangeListener<FileCollectionSnapshot.Merge>(){

                    @Override
                    public void added(FileCollectionSnapshot.Merge merge) {
                        merge.ignore();
                    }

                    @Override
                    public void removed(FileCollectionSnapshot.Merge merge) {
                    }

                    @Override
                    public void changed(FileCollectionSnapshot.Merge merge) {
                    }
                });
                FileCollectionSnapshot fileCollectionSnapshot3 = OutputFilesChangedUpToDateRule.this.outputFilesSnapshotter.snapshot(taskInternal.getOutputs().getFiles());
                taskExecution2.setOutputFilesSnapshot(fileCollectionSnapshot3.changesSince(fileCollectionSnapshot).applyTo(fileCollectionSnapshot2));
            }
        };
    }
}

